### Name: summary.spotseg
### Title: Microarray Spot Segmentation Summary
### Aliases: summary.spotseg
### Keywords: methods

### ** Examples

data(spotSegTest)

# columns of spotSegTest:
#  1 intensities from the Cy3 (green) channel
#  2 intensities from the Cy5 (red) channel

dataTransformation <- function(x) (256*256-1-x)^2*4.71542407E-05 

chan1 <- matrix(dataTransformation(spotSegTest[,1]), 144, 199)
chan2 <- matrix(dataTransformation(spotSegTest[,2]), 144, 199)

hivGrid <- spotgrid( chan1, chan2, rows = 4, cols = 6, show = TRUE)

library(mclust)

hivSeg <- spotseg( chan1, chan2, hivGrid$rowcut, hivGrid$colcut)

hivSummary <- summary(hivSeg)



