### Name: ebam
### Title: Empirical Bayes Analysis of Microarrays
### Aliases: ebam
### Keywords: htest

### ** Examples
## Not run: 
##D     library(multtest)
##D     # Load the data of Golub et al. (1999). data(golub) contains 
##D     # a 3051x38 gene expression matrix called golub, a vector of
##D     # length called golub.cl that consists of the 38 class labels,
##D     # and a matrix called golub.gnames whose third column contains
##D     # the gene names.
##D     data(golub)
##D     
##D     # The optimal value for the fudge factor a0 is computed, where
##D     # possible values of the a0 are 0 and the 0, 0.05 and 0.1 quantile
##D     # of the standard deviations of the genes. Setting rand=123
##D     # makes the results reproducible.
##D     
##D     find.out<-find.a0(golub,golub.cl,alpha=c(0,0.05,0.1),rand=123)
##D     
##D     # Now that we have find the optimal value of a0, an empirical Bayes
##D     # analysis can be performed.
##D     
##D     ebam.out<-ebam(find.out,gene.names=golub.gnames[,3])
##D     
##D     # For further analyses the row numbers of the differentially expressed
##D     # genes are obtained by
##D     
##D     ebam.out$row.sig.genes
## End(Not run)


