### Name: reset-methods
### Title: Reset a goCluster-module
### Aliases: reset
### Keywords: methods

### ** Examples


## Load small a test dataset
data(benomylsetupsmall)

## Create an empty goCluster object
test <- new("goCluster")

## Assign the configuration to the object and directly execute it
execute(test) <- benomylsetupsmall

## Change the configuration
## (Number of clusters are changed to 3)
test@algo@clusters <- 3

## After that it should not be executable again
failure <- try(execute(test))
if (!inherits(failure, "try-error")) stop("The goCluster object should not be executable a second time!")

## Reset the object
test <- reset(test)
## This should run fine
test <- execute(test)

  


