### Name: readIntensities
### Title: readIntensities
### Aliases: readIntensities
### Keywords: IO

### ** Examples


   ## Don't show: 

       LOADPATH <- file.path(.path.package("arrayMagic"), "extdata")

        slideDescription <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesDescription"
                           )
       dataColumns=c("a","b","c","d")
       names(dataColumns)= c("greenForeground","greenBackground",
                             "redForeground","redBackground")
       resultObject <- readIntensities(slideDescription=slideDescription,
                                       fileNameColumn="files",
                                       loadPath=LOADPATH,
                                       type="generic",
                                       spotAnnoColumns=c("e","f"),
                                       dataColumns=dataColumns,
                                       skip=7
                                      )

        slideDescriptionB <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesTwoColourDescription"
                           )
       channelColumn <-  "channel"
       resultObjectB <- readIntensities(slideDescription=slideDescriptionB,
                                        fileNameColumn="files",
                                        loadPath=LOADPATH,
                                        channelColumn=channelColumn,
                                        type="generic",
                                        spotAnnoColumns=c("e","f"),
                                        dataColumns=dataColumns,
                                        skip=7
                                       )
        slideDescriptionC <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesTwoColourDescription2"
                           )
       channelColumn <-  c("channel","xgreen","xred")
       names(channelColumn) <- c("channelColumnName", "green", "red")
       resultObjectC <- readIntensities(slideDescription=slideDescriptionC,
                                        fileNameColumn="files",
                                        loadPath=LOADPATH,
                                        channelColumn=channelColumn,
                                        type="generic",
                                        spotAnnoColumns=c("e","f"),
                                        dataColumns=dataColumns,
                                        skip=7
                                       )

     stopifnot( all( match(unlist(getHybAttr(resultObjectB)), unlist(getHybAttr(resultObjectC)))))
      stopifnot( all(unlist(getHybAttrRed(resultObjectB)[,c("files","name","sample")]) ==
                     unlist(getHybAttrRed(resultObjectC)[c(1,3,2),c("files","name","sample")])))

      stopifnot( all(unlist(getHybAttrGreen(resultObjectB)[,c("files","name","sample")]) ==
                     unlist(getHybAttrGreen(resultObjectC)[c(1,3,2),c("files","name","sample")])))

        slideDescriptionD <- readpDataSlides(
                             loadPath=LOADPATH, 
                             slideDescriptionFile="genericSlidesTwoColourDescription3"
                           )
       channelColumn <-  c("channel","xgreen","xred")
       names(channelColumn) <- c("channelColumnName", "green", "red")
       resultObjectD <- readIntensities(slideDescription=slideDescriptionD,
                                        fileNameColumn="files",
                                        loadPath=LOADPATH,
                                        channelColumn=channelColumn,
                                        type="generic",
                                        spotAnnoColumns=c("e","f"),
                                        dataColumns=dataColumns,
                                        skip=7
                                       )
     stopifnot( all( match(unlist(getHybAttr(resultObjectC)), unlist(getHybAttr(resultObjectD)))))

 stopifnot( all(getHybAttrRed(resultObjectC)[,c("files","name","sample","channel")] ==
                getHybAttrRed(resultObjectD)[,c("files","name","sample","channel")]))

 stopifnot( all(getHybAttrGreen(resultObjectC)[,c("files","name","sample","channel")] ==
                getHybAttrGreen(resultObjectD)[,c("files","name","sample","channel")]))

slideDescription <- data.frame(fileName="lc7b048rex2.DAT")
r <- readIntensities(slideDescription=slideDescription, loadPath=LOADPATH, type="ScanAlyze")
slideDescription <- data.frame(fileName="lc7b048rex.DAT")
r2 <- readIntensities(slideDescription=slideDescription, loadPath=LOADPATH, type="ScanAlyze")
 spotAnnoColumns <- c( "HEADER", "SPOT", "GRID", "ROW", "COL" )
 dataColumns <- c("CH1I", "CH1B", "CH2I", "CH2B")
 names(dataColumns) <-  c("greenForeground","greenBackground","redForeground","redBackground")
  r3 <- readIntensities(slideDescription=slideDescription, loadPath=LOADPATH, spotAnnoColumns = spotAnnoColumns, dataColumns=dataColumns, type="generic")
 stopifnot(  all( getIntensities(r) == getIntensities(r2) ) )
 stopifnot(  all( getIntensities(r) == getIntensities(r3) ) )

   ## End Don't show

 


