### Name: getModelInfo
### Title: Get info from an SBML model
### Aliases: getModelInfo
### Keywords: math

### ** Examples

library(SBMLR)  
curto=readSBMLR(file.path(.path.package("SBMLR"), "models/curto.r"))  
mi=getModelInfo(curto);mi
attach(mi)
y0
nReactions

# Metabolic Control Analysis of Curto's purine metabolism model
library(SBMLR)  
curto=readSBMLR(file.path(.path.package("SBMLR"), "models/curto.r"))  

mi=getModelInfo(curto)
attach(mi)
N=incid
S0bk=S0
p0=S0[BC==TRUE]

#qr(N)
# full rank => Nr=N and L=I
J=NULL;
for (j in 1:nReactions) 
J[j]=curto$reactions[[j]]$law(S0[c(curto$reactions[[j]]$reactants,curto$reactions[[j]]$modifiers)],curto$reactions[[j]]$parameters)
names(J)<-rIDs
J
DJ=diag(J)

epsS=matrix(rep(0,nReactions*nStates),nrow=nReactions)
rownames(epsS)<-rIDs
colnames(epsS)<-names(y0)
epsS

for (k in 1:nStates) 
#for (k in 1:1) 
{S0=S0bk
y1=y0
y1[k]=1.01*y0[k]
S0=c(y1,p0)
for (j in 1:nReactions) 
epsS[j,k]=(curto$reactions[[j]]$law(S0[c(curto$reactions[[j]]$reactants,curto$reactions[[j]]$modifiers)],curto$reactions[[j]]$parameters)-J[j])/(.01*J[j])
}
epsS
DS=diag(y0)
dSdVm=-solve(N%*%DJ%*%epsS)%*%N%*%DJ
colnames(dSdVm)<-rIDs
dSdVm #  compare this output to Figure 2 of Curto et al 1997
apply(dSdVm,1,sum)
dJdVm=epsS%*%dSdVm+diag(rep(1,length(rIDs)));dJdVm # this compares well with Figure 3 of Curto et al 1997
apply(dJdVm,1,sum)






