### Name: imageMap-methods
### Title: Write an HTML IMG tag together with a MAP image map.
### Aliases: imageMap imageMap-methods imageMap,Ragraph-method
###   imageMap,Ragraph,connection,list,character-method
### Keywords: iplot

### ** Examples

fhtml = paste(tempfile(), ".html", sep="")
fpng  =paste(tempfile(), ".png", sep="")

if(capabilities()["png"] && interactive()) {

  ## Create and layout a random graph
  set.seed(123)
  g  = randomEGraph(letters[14:22], 0.2)
  lg = agopen(g, name="My layout")

  ## Make tooltips and hyperlinks
  tooltip = paste("This is node", nodes(g))
  url = paste("This could be a link for node", nodes(g))
  names(url) = names(tooltip) = nodes(g)

  ## Plot it
  width = height = 512
  png(fpng, width=width, height=height)
  par(mai=rep(0,4))
  plot(g)

  ## Write an HTML file with the image map
  con = file(fhtml, open="wt")
  writeLines("<html><head><title>Click Me</title></head><body>\n", con)

  imageMap(lg, con, fpng, tags=list(HREF=url, TITLE=tooltip), width=width, height=height)

  writeLines("</body></html>", con)
  dev.off()
  close(con)
  cat("Now have a look at file", fhtml, "with your browser.\n")
}



