### Name: ggm.test.edges
### Title: Graphical Gaussian Models: Testing Edges
### Aliases: ggm.test.edges
### Keywords: htest

### ** Examples

# load GeneTS library
library("GeneTS")
 
# generate random network with 20 nodes and 5 percent edges
true.pcor <- ggm.simulate.pcor(20, 0.05)

# simulate data set of length 100
sim.dat <- ggm.simulate.data(100, true.pcor)

# estimate partial correlation matrix (simple estimator)
inferred.pcor <- ggm.estimate.pcor(sim.dat)

# p-values, q-values and posterior probabilities for each edge 
#
# try both options for fA!
#test.results <- ggm.test.edges(inferred.pcor, fA.type="nonparametric")
test.results <- ggm.test.edges(inferred.pcor, fA.type="uniform")

# show best 20 edges (strongest correlation)
test.results[1:20,]

# how many are significant based on FDR cutoff Q=0.05 ?
num.significant.1 <- sum(test.results$qval <= 0.05)
test.results[1:num.significant.1,]

# how many are significant based on "local fdr" cutoff (prob > 0.95) ?
num.significant.2 <- sum(test.results$prob > 0.95)
test.results[1:num.significant.2,]

# parameters of the mixture distribution used to compute p-values etc.
c <- cor.fit.mixture(sm2vec(inferred.pcor), fA.type="uniform")
c$eta0
c$kappa



