### Name: cor0.estimate.kappa
### Title: Estimating the Degree of Freedom of the Null Distribution of the
###   Correlation Coefficient
### Aliases: cor0.estimate.kappa
### Keywords: htest

### ** Examples

# load GeneTS library
library("GeneTS")

# distribution of r for kappa=7
x <- seq(-1,1,0.01)
y <- dcor0(x, kappa=7)

# simulated data
r <- rcor0(1000, kappa=7)
hist(r, freq=FALSE, 
  xlim=c(-1,1), ylim=c(0,5))
lines(x,y,type="l")

# estimate kappa
cor0.estimate.kappa(r)



