### Name: eSet
### Title: General Container for High-Throughput Assays and Experimental
###   Metadata
### Aliases: eSet class:eSet listOrEnv eList SW SWPD swrep golubMergeSub
###   assayData
### Keywords: classes

### ** Examples

# eSet 1 is loaded
data(eset)
pd <- phenoData(eset)
xl <- list(e1=exprs(eset))
gn <- geneNames(eset)
sn <- sampleNames(eset)

# eSet 2 is constructed
es2 <- new("eSet", phenoData=pd, assayData=xl,
  reporterNames=gn, sampleNames=sn)

# illustrate subset and show for assayData as list
es2[1:4,1:4]

# build with environment assayData
eenv <- new.env()
assign("e1", assayData(eset), eenv)
es3 <- new("eSet", phenoData=pd, assayData=eenv,
  reporterNames=gn, sampleNames=sn)
es3
es3[1:5,1:5]

# show some legacy behavior: set list element name to
# exprs and invoke exprs()
names(assayData(es2)) <- "exprs"
dim(exprs(es2))

# show some validity checking
assayData(es3) <- assayData(es2)
es3  # now has list
sampleNames(es2) <- letters # ok
if (interactive()) {
 lk <- try(sampleNames(es2) <- letters[-1]) # not ok
 lk
 lk <- try(assayData(es2) <- assayData(es2[-1,])) # not ok
 class(lk)
 }

# work with the swirl data
data(SW)
data(swrep)
data(SWPD)
sw <- new("eSet",
  assayData=list( R=SW$R, G=SW$G, Rb=SW$Rb, Gb=SW$Gb),
  phenoData=SWPD, reporterInfo=swrep, sampleNames=as.character(1:4),
  reporterNames=as.character(swrep$Name))



