###################################################
### chunk number 1: 
###################################################
library(mBPCR)


###################################################
### chunk number 2: 
###################################################
data(rec10k)


###################################################
### chunk number 3: 
###################################################
maxProbeNumber <- 1000


###################################################
### chunk number 4: 
###################################################
A <- array(1, dim=(maxProbeNumber+1)*(maxProbeNumber+2)/2)


###################################################
### chunk number 5: 
###################################################
remove(A)


###################################################
### chunk number 6: 
###################################################
results <- estProfileWithMBPCR(rec10k$SNPname, rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBeAnalyzed=c(3,5), maxProbeNumber=1000)


###################################################
### chunk number 7: 
###################################################
writeEstProfile(path='', sampleName='rec10k',rec10k$SNPname, rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBeWritten=c(3,5), results$estPC, results$estBoundaries)


###################################################
### chunk number 8: 
###################################################
library(xtable)
temp <- writeEstProfile(path=NULL, sampleName='rec10k',rec10k$SNPname,rec10k$Chromosome,  rec10k$PhysicalPosition, rec10k$log2ratio,chrToBeWritten=c(3,5), results$estPC, results$estBoundaries) 


###################################################
### chunk number 9: genTable1
###################################################
xx <- xtable(head(temp$mBPCRestimate))
label(xx) <- "tab_mBPCR"
caption(xx) <- "Example of table containing the profile estimated with mBPCR."
align(xx) <- c("|c|","|c|","c|","c|","c|","c|")
print(xx,latex.environments=c("center","small"),include.rownames=FALSE)


###################################################
### chunk number 10: genTable2
###################################################
xx <- xtable(head(temp$mBPCRbreakpoints))
label(xx) <- "tab_bounds"
caption(xx) <- "Example of table containing a summary of the breakpoints estimated with mBPCR."
align(xx) <- c("|c|","|c|","c|","c|","c|","c|","c|","c|")
print(xx,latex.environments=c("center","small"),include.rownames=FALSE)


###################################################
### chunk number 11: 
###################################################
results <- estProfileWithMBPCR(rec10k$SNPname, rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBeAnalyzed=3, regr='BRC', maxProbeNumber=1000)


###################################################
### chunk number 12: 
###################################################
plotEstProfile(sampleName='rec10k', rec10k$Chromosome, rec10k$PhysicalPosition, rec10k$log2ratio, chrToBePlotted=3, results$estPC, maxProbeNumber=2000, regrCurve=results$regrCurve, regr='BRC')


###################################################
### chunk number 13:  eval=FALSE
###################################################
## data(jekoChr11Array250Knsp)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## maxProbeNumber <- 9000


###################################################
### chunk number 15:  eval=FALSE
###################################################
## A <- array(1, dim=(maxProbeNumber+1)*(maxProbeNumber+2)/2)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## remove(A)


###################################################
### chunk number 17:  eval=FALSE
###################################################
## results <- estProfileWithMBPCR(jekoChr11Array250Knsp$SNPname, jekoChr11Array250Knsp$Chromosome, jekoChr11Array250Knsp$PhysicalPosition, jekoChr11Array250Knsp$log2ratio, chrToBeAnalyzed=11, maxProbeNumber=9000, rhoSquare=0.0479, nu=-3.012772e-10, sigmaSquare=0.0699)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## plotEstProfile(sampleName='jeko250Knsp', jekoChr11Array250Knsp$Chromosome, jekoChr11Array250Knsp$PhysicalPosition, jekoChr11Array250Knsp$log2ratio, chrToBePlotted=11, results$estPC, maxProbeNumber=9000)


###################################################
### chunk number 19: 
###################################################
data(rec10k)


###################################################
### chunk number 20: 
###################################################
estGlobParam(rec10k$log2ratio)


###################################################
### chunk number 21: 
###################################################
data(jekoChr11Array250Knsp)


###################################################
### chunk number 22: 
###################################################
y <- jekoChr11Array250Knsp$log2ratio[10600:11200]


###################################################
### chunk number 23: 
###################################################
p <- jekoChr11Array250Knsp$PhysicalPosition[10600:11200]


###################################################
### chunk number 24: 
###################################################
results <- computeMBPCR(y, nu=-3.012772e-10, rhoSquare=0.0479, sigmaSquare=0.0699, regr='BRC')


###################################################
### chunk number 25: 
###################################################
plot(p,y)
points(p, results$estPC, type='l', col='red')
points(p, results$regrCurve, type='l', col='green')
legend(x='bottomleft', legend=c('mBPCR', 'BRC with K_2'), lty=c(1, 1), col=c(4, 2))


###################################################
### chunk number 26: 
###################################################
path <- system.file("extdata", "rec10k.txt", package = "mBPCR")


###################################################
### chunk number 27: 
###################################################
rec10k <- importCNData(path, NRowSkip=1)


###################################################
### chunk number 28: 
###################################################
plot(rec10k$position[rec10k$chr == 3], rec10k$logratio[rec10k$chr == 3], xlab='Chromosome 3', ylab='log2ratio')        


###################################################
### chunk number 29: 
###################################################
library(SNPchip)


###################################################
### chunk number 30: 
###################################################
data(sample.snpset)


###################################################
### chunk number 31: 
###################################################
library(mBPCR)


###################################################
### chunk number 32: 
###################################################
r <- estProfileWithMBPCRforOligoSnpSet(sample.snpset, sampleToBeAnalyzed=3:4, chrToBeAnalyzed=8, maxProbeNumber=1000, ifLogRatio=0, rhoSquare= 0.0889637)


###################################################
### chunk number 33: 
###################################################
cc <- r$estPC


###################################################
### chunk number 34: 
###################################################
cc1 <- cc[chromosome(cc) == 8,3:4]


###################################################
### chunk number 35: 
###################################################
plotSnp(cc1)


