###################################################
### chunk number 1: library
###################################################
library(globaltest)


###################################################
### chunk number 2: deprecated
###################################################
gt.options(warn.deprecated=FALSE)


###################################################
### chunk number 3: options
###################################################
options(continue = "  ")


###################################################
### chunk number 4: getGolubData
###################################################
library(golubEsets)
library(vsn)
data(Golub_Merge)
Golub<-Golub_Merge[,1:34]
exprs(Golub)<-exprs(vsn2(Golub_Merge[,1:34]))


###################################################
### chunk number 5: getNKIData
###################################################
library(globaltest)
data(vandeVijver)


###################################################
### chunk number 6: loadKEGGandGO
###################################################
library(hu6800.db)
kegg <- as.list(hu6800PATH2PROBE)
go <- as.list(hu6800GO2ALLPROBES)


###################################################
### chunk number 7: cleanGO
###################################################
go <- lapply(go, function(x) x[!is.na(names(x)) & (names(x) != "IEA")])


###################################################
### chunk number 8: makeCellcycle
###################################################
GO.cellcycle <- go[["GO:0007049"]]
KEGG.cellcycle <- kegg[["04110"]]


###################################################
### chunk number 9: all
###################################################
gt.all <- globaltest(Golub, "ALL.AML")


###################################################
### chunk number 10: all.display
###################################################
gt.all


###################################################
### chunk number 11: cellcycle
###################################################
globaltest(Golub, "ALL.AML", GO.cellcycle)


###################################################
### chunk number 12: twocellcycle
###################################################
cellcycle <- list(go = GO.cellcycle, kegg = KEGG.cellcycle)
globaltest(Golub, "ALL.AML", cellcycle)


###################################################
### chunk number 13: kegg
###################################################
gt.kegg <- globaltest(Golub, "ALL.AML", kegg)


###################################################
### chunk number 14: kegg.display eval=FALSE
###################################################
## gt.kegg["04110"]
## gt.kegg[1:10]


###################################################
### chunk number 15: sort.by.p
###################################################
sorted <- sort(gt.kegg)
top5 <- sorted[1:5]
top5


###################################################
### chunk number 16: kegg.numbers.to.names
###################################################
library(KEGG.db)
names(top5) <- as.list(KEGGPATHID2NAME)[names(top5)]
top5


###################################################
### chunk number 17: useful
###################################################
p.value(top5)
names(top5)
result(top5)
length(top5)


###################################################
### chunk number 18: multtest
###################################################
sorted <- gt.multtest(sorted, "FWER")
sorted[1:5]


###################################################
### chunk number 19: golub_Source
###################################################
globaltest(Golub, "Source")


###################################################
### chunk number 20: golub_Source_2levels
###################################################
globaltest(Golub, "Source", levels = c("CALGB", "CCG"))


###################################################
### chunk number 21: golub_Source_1level
###################################################
globaltest(Golub, "Source", levels = "St-Jude")


###################################################
### chunk number 22: golub_Source_factor eval=FALSE
###################################################
## globaltest(Golub, "factor(Source)")


###################################################
### chunk number 23: golub_pctBlasts
###################################################
calgb <- pData(Golub)["Source"] == "CALGB"
globaltest(Golub[,calgb], "pctBlasts")


###################################################
### chunk number 24: vandeVijver_survival
###################################################
library(survival)
globaltest(vandeVijver, "Surv(TIMEsurvival, EVENTdeath)")


###################################################
### chunk number 25: vandeVijver_survival_alternatives eval=FALSE
###################################################
## globaltest(vandeVijver, "Surv(TIMEsurvival, EVENTdeath == 1)")
## globaltest(vandeVijver, "TIMEsurvival", d = "EVENTdeath")
## globaltest(vandeVijver, "TIMEsurvival", d = "EVENTdeath", event = 1)


###################################################
### chunk number 26: method
###################################################
globaltest(Golub, "ALL.AML", GO.cellcycle, method = "p", nperm = 1000)


###################################################
### chunk number 27: permutations
###################################################
gt <- globaltest(Golub, "ALL.AML", GO.cellcycle)
permutations(gt, nperm = 2000)


###################################################
### chunk number 28: golub_adjust_BM.PB
###################################################
globaltest(Golub, ALL.AML ~ BM.PB, GO.cellcycle)


###################################################
### chunk number 29: vijver_adjust_all
###################################################
globaltest(vandeVijver, Surv(TIMEsurvival, EVENTdeath) ~ NIH + ESR1 + Posnodes)


###################################################
### chunk number 30: vijver_esr1
###################################################
globaltest(vandeVijver, "ESR1")


###################################################
### chunk number 31: golub_adjust_AML.ALL
###################################################
gt <- globaltest(vandeVijver, Surv(TIMEsurvival, EVENTdeath) ~ ESR1)
fit(gt)


###################################################
### chunk number 32: sampling
###################################################
gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle)
sampled.gt <- sampling(gt)
sampled.gt


###################################################
### chunk number 33: hist eval=FALSE
###################################################
## gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle, method = "p")
## hist(gt)


###################################################
### chunk number 34: hist-plot
###################################################
gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle, method = "p")
hist(gt)


###################################################
### chunk number 35: geneplot
###################################################
gt <- globaltest(Golub, "ALL.AML", kegg)
geneplot(gt, "00561")


###################################################
### chunk number 36: geneplot_store
###################################################
myplot <- geneplot(gt, "00561", plot = FALSE)


###################################################
### chunk number 37: geneplot_changenames
###################################################
names(myplot) <- as.list(hu6800SYMBOL)[names(myplot)]
plot(myplot)


###################################################
### chunk number 38: geneplot_changenames2
###################################################
plot(myplot)


###################################################
### chunk number 39: geneplot_sort
###################################################
mysorted <- sort(myplot)
top5 <- mysorted[1:5]


###################################################
### chunk number 40: geneplot_utilities
###################################################
z.score(top5)
names(top5)
result(top5)
length(top5)


###################################################
### chunk number 41: sampleplot
###################################################
gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle)
sampleplot(gt)


###################################################
### chunk number 42: sampleplot-plot
###################################################
sampleplot(gt)


###################################################
### chunk number 43: checkerboard
###################################################
gt <- globaltest(Golub, "ALL.AML", kegg)
checkerboard(gt.kegg, "04110")


###################################################
### chunk number 44: checkerboard-plot
###################################################
checkerboard(gt, "04110")


###################################################
### chunk number 45: regressionplot
###################################################
gt <- globaltest(Golub, "ALL.AML", kegg)
regressionplot(gt, "04110", sampleid = "39")


###################################################
### chunk number 46: regressionplot2
###################################################
regressionplot(gt, "04110", sampleid = c("39","40"))


###################################################
### chunk number 47: regressionplot-plot
###################################################
regressionplot(gt, "04110", "39")


###################################################
### chunk number 48: 
###################################################
toLatex(sessionInfo())


