/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.datamatrix;

import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;

public class LensedDataMatrix
extends DataMatrix
implements Serializable {
    int[] columnOrder;
    boolean[] columnState;
    boolean[] rowState;
    int[] rowMap;
    boolean noExplicitRowSelection = true;
    DataMatrix underlyingMatrix;
    Hashtable nameMap = new Hashtable();

    public LensedDataMatrix(DataMatrix matrix) throws Exception {
        this.underlyingMatrix = matrix;
        this.rowTitlesTitle = matrix.getRowTitlesTitle();
        this.columnTitles = matrix.getColumnTitles();
        this.rowTitles = matrix.getRowTitles();
        this.data = matrix.get();
        this.uri = matrix.getFullName();
        this.fullName = matrix.getFullName();
        this.shortName = matrix.getShortName();
        this.fileExtension = matrix.getFileExtension();
        this.dataTypeBriefName = matrix.getDataTypeBriefName();
        this.species = matrix.getSpecies();
        for (int i = 0; i < this.rowTitles.length; ++i) {
            this.nameMap.put(this.rowTitles[i], new Integer(i));
        }
        this.init();
    }

    public DataMatrix getUnderlyingMatrix() {
        return this.underlyingMatrix;
    }

    private void init() {
        this.clear();
    }

    public void clear() {
        int columnCount = this.columnTitles.length;
        this.columnState = new boolean[columnCount];
        this.columnOrder = new int[columnCount];
        for (int c = 0; c < columnCount; ++c) {
            this.columnState[c] = true;
            this.columnOrder[c] = c;
        }
        this.rowState = new boolean[this.rowTitles.length];
        this.setRowState(false);
        this.noExplicitRowSelection = true;
    }

    public void setColumnState(boolean newState) {
        for (int c = 0; c < this.columnState.length; ++c) {
            this.columnState[c] = newState;
        }
    }

    public void setColumnState(int[] columns, boolean newState) {
        for (int c = 0; c < columns.length; ++c) {
            this.columnState[columns[c]] = newState;
        }
    }

    public void setColumnState(int column, boolean newState) {
        this.columnState[column] = newState;
    }

    public boolean[] getColumnState() {
        return this.columnState;
    }

    public boolean getColumnState(int column) {
        return this.columnState[column];
    }

    public void setRowState(boolean[] newState) {
        this.rowState = newState;
        this.updateRowMap();
    }

    public void setRowState(boolean newState) {
        for (int r = 0; r < this.underlyingMatrix.getRowCount(); ++r) {
            this.setRowStateImpl(r, newState);
        }
        this.updateRowMap();
    }

    public void setRowState(int[] rows, boolean newState) {
        for (int r = 0; r < rows.length; ++r) {
            this.setRowStateImpl(rows[r], newState);
        }
        this.updateRowMap();
    }

    public void setRowState(int row, boolean newState) {
        this.setRowStateImpl(row, newState);
        this.updateRowMap();
    }

    private void setRowStateImpl(int row, boolean newState) {
        this.rowState[row] = newState;
    }

    public void enableRow(int row) {
        this.setRowStateImpl(row, true);
        this.updateRowMap();
    }

    public void enableRows(int[] rows) {
        this.setRowState(rows, true);
    }

    public void enableAllRows() {
        for (int i = 0; i < this.rowState.length; ++i) {
            this.setRowStateImpl(i, true);
        }
        this.updateRowMap();
    }

    public void disableRow(int row) {
        this.setRowStateImpl(row, false);
        this.updateRowMap();
    }

    public void disableRows(int[] rows) {
        this.setRowState(rows, false);
    }

    public void disableAllRows() {
        Arrays.fill(this.rowState, false);
        this.updateRowMap();
    }

    private void updateRowMap() {
        this.rowMap = new int[this.rowState.length];
        Arrays.fill(this.rowMap, -1);
        int enabledRowCount = 0;
        for (int r = 0; r < this.rowState.length; ++r) {
            if (!this.rowState[r]) continue;
            this.rowMap[enabledRowCount++] = r;
        }
    }

    public void enableColumn(int column) {
        this.setColumnState(column, true);
    }

    public void enableColumns(int[] columns) {
        this.setColumnState(columns, true);
    }

    public void enableAllColumns() {
        for (int i = 0; i < this.columnState.length; ++i) {
            this.setColumnState(i, true);
        }
    }

    public void disableColumn(int column) {
        this.setColumnState(column, false);
    }

    public void disableColumns(int[] columns) {
        this.setColumnState(columns, false);
    }

    public void disableAllColumns() {
        for (int i = 0; i < this.columnState.length; ++i) {
            this.setColumnState(i, false);
        }
    }

    public boolean[] getRowState() {
        return this.rowState;
    }

    public boolean getRowState(int row) {
        return this.rowState[row];
    }

    public int getRowCount() {
        int result = 0;
        for (int r = 0; r < this.rowState.length; ++r) {
            if (!this.rowState[r]) continue;
            ++result;
        }
        return result;
    }

    public int getColumnCount() {
        int result = 0;
        for (int i = 0; i < this.columnState.length; ++i) {
            if (!this.columnState[i]) continue;
            ++result;
        }
        return result;
    }

    public void changeColumnPosition(int from, int to) {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            v.add(new Integer(this.columnOrder[i]));
        }
        Integer move = (Integer)v.remove(from);
        v.add(to, move);
        for (int i = 0; i < this.columnOrder.length; ++i) {
            this.columnOrder[i] = (Integer)v.get(i);
        }
    }

    public int getColumnOrder(int column) {
        return this.columnOrder[column];
    }

    public String[] getColumnTitles() {
        return this.adjustTitlesForColumnOrderAndState(this.columnTitles);
    }

    public String[] getRowTitles() {
        String[] allRowTitles = this.underlyingMatrix.getRowTitles();
        ArrayList<String> result = new ArrayList<String>();
        for (int r = 0; r < this.rowState.length; ++r) {
            if (!this.rowState[r]) continue;
            result.add(allRowTitles[r]);
        }
        return result.toArray(new String[0]);
    }

    public int adjustRowIndexForRowState(int requestedRow) {
        if (requestedRow >= this.rowMap.length) {
            throw new IllegalArgumentException("requestedRow " + requestedRow + " is out of range.  visible row count: " + this.rowMap.length);
        }
        return this.rowMap[requestedRow];
    }

    public int oldAdjustRowIndexForRowState(int requestedRow) {
        int visibleRowCount = -1;
        for (int r = 0; r < this.rowState.length; ++r) {
            if (!this.rowState[r] || requestedRow != ++visibleRowCount) continue;
            return r;
        }
        throw new IllegalArgumentException("requestedRow " + requestedRow + " is out of range.  visible row count: " + this.getRowCount());
    }

    public DataMatrix getVisibleMatrix() {
        DataMatrix matrix = new DataMatrix(this.getFullName());
        matrix.setDataTypeBriefName(this.getDataTypeBriefName());
        matrix.setColumnTitles(this.getColumnTitles());
        matrix.setRowTitles(this.getRowTitles());
        matrix.setRowTitlesTitle(this.getRowTitlesTitle());
        matrix.setSpecies(this.getSpecies());
        matrix.set(this.get());
        return matrix;
    }

    public static DataMatrix toDataMatrix(LensedDataMatrix lens) {
        DataMatrix matrix = new DataMatrix();
        matrix.setRowTitlesTitle(lens.getRowTitlesTitle());
        matrix.setColumnTitles(lens.getColumnTitles());
        matrix.setRowTitles(lens.getRowTitles());
        matrix.set(lens.get());
        matrix.setFullName(lens.getFullName());
        matrix.setShortName(lens.getShortName());
        matrix.setDataTypeBriefName(lens.getDataTypeBriefName());
        matrix.setSpecies(lens.getSpecies());
        matrix.setName(lens.getName());
        matrix.setMetadata(lens.getMetadata());
        return matrix;
    }

    public String toString() {
        return this.getVisibleMatrix().toString();
    }

    public void printTransformation() {
        int i;
        int columnCount = this.columnState.length;
        System.out.print("column\t");
        for (i = 0; i < columnCount; ++i) {
            System.out.print(i + "\t");
        }
        System.out.println();
        System.out.println("---------------------------");
        System.out.print("order\t");
        for (i = 0; i < columnCount; ++i) {
            System.out.print(this.columnOrder[i] + "\t");
        }
        System.out.println();
        System.out.print("state\t");
        for (i = 0; i < columnCount; ++i) {
            String stateString = "F";
            if (this.columnState[i]) {
                stateString = "T";
            }
            System.out.print(stateString + "\t");
        }
        System.out.println();
        System.out.println();
        System.out.println("row\tstate\t");
        System.out.println("------------------");
        for (i = 0; i < this.rowState.length; ++i) {
            System.out.println(i + "\t" + this.rowState[i]);
        }
    }

    public double[] get(int row) {
        int correctedRow = this.adjustRowIndexForRowState(row);
        return this.adjustRowForColumnOrderAndState(this.underlyingMatrix.get(correctedRow));
    }

    public double get(int row, int column) {
        int correctedRow = this.adjustRowIndexForRowState(row);
        return this.adjustRowForColumnOrderAndState(this.underlyingMatrix.get(correctedRow))[column];
    }

    public double[] get(String rowName) {
        return this.adjustRowForColumnOrderAndState(this.underlyingMatrix.get(rowName));
    }

    public double[][] get() {
        double[][] result = new double[this.getRowCount()][this.getColumnCount()];
        for (int r = 0; r < this.getRowCount(); ++r) {
            result[r] = this.get(r);
        }
        return result;
    }

    public double[] getColumn(int columnNumber) {
        int correctedColumn = this.columnOrder[columnNumber];
        return this.underlyingMatrix.getColumn(correctedColumn);
    }

    public int getRowIndex(String rowName) {
        return (Integer)this.nameMap.get(rowName);
    }

    protected double[] adjustRowForColumnOrderAndState(double[] row) {
        int dataColumnCount = this.getColumnCount();
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (!this.columnState[i]) continue;
            double nextValue = row[this.columnOrder[i]];
            list.add(new Double(nextValue));
        }
        double[] result = new double[list.size()];
        Double[] tmp = list.toArray(new Double[0]);
        for (int i = 0; i < tmp.length; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    protected String[] adjustTitlesForColumnOrderAndState(String[] columnTitles) {
        int dataColumnCount = columnTitles.length;
        String[] movableTitles = new String[dataColumnCount];
        for (int i = 0; i < dataColumnCount; ++i) {
            movableTitles[i] = columnTitles[i];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (!this.columnState[i]) continue;
            String nextValue = movableTitles[this.columnOrder[i]];
            list.add(nextValue);
        }
        String[] result = list.toArray(new String[0]);
        return result;
    }

    public void addRow(String rowTitle, double[] values) {
        int oldMax = this.rowState.length;
        int newMax = oldMax + 1;
        int newRowNumber = oldMax;
        boolean[] newRowState = new boolean[newMax];
        for (int i = 0; i < oldMax; ++i) {
            newRowState[i] = this.rowState[i];
        }
        this.nameMap.put(rowTitle, new Integer(newRowNumber));
        newRowState[newRowNumber] = true;
        this.rowState = newRowState;
        this.underlyingMatrix.addRow(rowTitle, values);
        this.updateRowMap();
    }

    public static void transposeMatrix(DataMatrix matrix) {
        LensedDataMatrix.transposeMatrix(matrix, null);
    }

    public static void transposeMatrix(DataMatrix matrix, String rowTitlesTitle) {
        if (rowTitlesTitle != null) {
            matrix.setRowTitlesTitle(rowTitlesTitle);
        }
        SparseDoubleMatrix2D coltMatrix = new SparseDoubleMatrix2D(matrix.get());
        matrix.set(coltMatrix.viewDice().toArray());
        String[] tmp = matrix.getColumnTitles();
        matrix.setColumnTitles(matrix.getRowTitles());
        matrix.setRowTitles(tmp);
    }
}

