/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.core.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.gaggle.core.datatypes.GaggleData;
import org.systemsbiology.gaggle.core.datatypes.Interaction;
import org.systemsbiology.gaggle.core.datatypes.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
implements GaggleData {
    List<Interaction> interactionList = new ArrayList<Interaction>();
    Map<String, HashMap<String, Object>> nodeAttributes = new HashMap<String, HashMap<String, Object>>();
    Map<String, HashMap<String, Object>> edgeAttributes = new HashMap<String, HashMap<String, Object>>();
    Set<String> nodes = new HashSet<String>();
    String species = "unknown";
    String name;
    Tuple metadata;

    public void add(Interaction interaction) {
        this.interactionList.add(interaction);
        this.add(interaction.getSource());
        this.add(interaction.getTarget());
    }

    public void add(String nodeName) {
        this.nodes.add(nodeName);
    }

    public void add(Interaction[] interactions) {
        for (Interaction interaction : interactions) {
            this.add(interaction);
        }
    }

    public Interaction[] getInteractions() {
        return this.interactionList.toArray(new Interaction[0]);
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public String[] getNodes() {
        return this.nodes.toArray(new String[0]);
    }

    public HashSet<String> getConnectedNodes() {
        Interaction[] interactions;
        HashSet<String> result = new HashSet<String>();
        for (Interaction interaction : interactions = this.getInteractions()) {
            result.add(interaction.getSource());
            result.add(interaction.getTarget());
        }
        return result;
    }

    public String[] getOrphanNodes() {
        String[] allNodes;
        HashSet<String> result = new HashSet<String>();
        HashSet<String> connectedNodes = this.getConnectedNodes();
        for (String node : allNodes = this.getNodes()) {
            if (connectedNodes.contains(node)) continue;
            result.add(node);
        }
        return result.toArray(new String[0]);
    }

    public int getOrphanNodeCount() {
        return this.getOrphanNodes().length;
    }

    public int edgeCount() {
        return this.interactionList.size();
    }

    protected void validateObjectType(Object value) {
        if (!(value instanceof Double || value instanceof String || value instanceof Integer || value instanceof Vector)) {
            throw new IllegalArgumentException("Value must be a String, Double, or Integer.");
        }
    }

    public void addEdgeAttribute(String edgeName, String attributeName, Object value) {
        this.validateObjectType(value);
        if (!this.edgeAttributes.containsKey(attributeName)) {
            this.edgeAttributes.put(attributeName, new HashMap());
        }
        HashMap<String, Object> attributeHash = this.edgeAttributes.get(attributeName);
        attributeHash.put(edgeName, value);
    }

    public void addNodeAttribute(String nodeName, String attributeName, Object value) {
        this.validateObjectType(value);
        if (!this.nodeAttributes.containsKey(attributeName)) {
            this.nodeAttributes.put(attributeName, new HashMap());
        }
        HashMap<String, Object> attributeHash = this.nodeAttributes.get(attributeName);
        attributeHash.put(nodeName, value);
    }

    public String[] getNodeAttributeNames() {
        return this.nodeAttributes.keySet().toArray(new String[0]);
    }

    public String[] getEdgeAttributeNames() {
        return this.edgeAttributes.keySet().toArray(new String[0]);
    }

    public HashMap getEdgeAttributes(String attributeName) {
        return this.edgeAttributes.get(attributeName);
    }

    public HashMap getNodeAttributes(String attributeName) {
        return this.nodeAttributes.get(attributeName);
    }

    public void setSpecies(String newValue) {
        this.species = newValue;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Tuple getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Tuple metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        Interaction[] interactions;
        StringBuffer sb = new StringBuffer();
        for (Interaction interaction : interactions = this.getInteractions()) {
            sb.append(interaction.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

