###################################################
### chunk number 1: loadPacks
###################################################
library(clippda)


###################################################
### chunk number 2: setWidth
###################################################
options(width=60)


###################################################
### chunk number 3: liverdata
###################################################
data(liverdata)
data(liverRawData)
data(liver_pheno)
liverdata[1:4,]
liverRawData[1:4,]


###################################################
### chunk number 4: decription1
###################################################
names(liverdata)
dim(liverdata)


###################################################
### chunk number 5: checkNo.replicates
###################################################
no.peaks <- 53
no.replicates <- 2
checkNo.replicates(liverRawData,no.peaks,no.replicates) 


###################################################
### chunk number 6: preProcRepeatedPeakData
###################################################
threshold <- 0.80 
Data <- preProcRepeatedPeakData(liverRawData, no.peaks, no.replicates, threshold)


###################################################
### chunk number 7: difference
###################################################
setdiff(unique(liverRawData$SampleTag),unique(liverdata$SampleTag))
setdiff(unique(Data$SampleTag),unique(liverdata$SampleTag))


###################################################
### chunk number 8: spectrumFilter
###################################################
TAGS <- spectrumFilter(Data,threshold,no.peaks)$SampleTag
NewRawData2 <- Data[Data$SampleTag %in% TAGS,]
dim(Data)
dim(liverdata)
dim(NewRawData2)


###################################################
### chunk number 9: no.replicates
###################################################
length(liverRawData[liverRawData$SampleTag == 25,]$Intensity)/no.peaks
length(liverRawData[liverRawData$SampleTag == 40,]$Intensity)/no.peaks


###################################################
### chunk number 10: coherencepeaks
###################################################
Mat1 <- matrix(liverRawData[liverRawData$SampleTag == 25,]$Intensity,53,3)
Mat2 <-matrix(liverRawData[liverRawData$SampleTag == 40,]$Intensity,53,4)
cor(log2(Mat1))
cor(log2(Mat2))


###################################################
### chunk number 11: coherencepeaks
###################################################
Mat1 <- matrix(liverRawData[liverRawData$SampleTag == 25,]$Intensity,53,3)
Mat2 <-matrix(liverRawData[liverRawData$SampleTag == 40,]$Intensity,53,4)
sort(mostSimilarTwo(cor(log2(Mat1))))
sort(mostSimilarTwo(cor(log2(Mat2))))


###################################################
### chunk number 12: confirmpreprocessing
###################################################
names(NewRawData2)
dim(NewRawData2)
names(liverdata)
dim(liverdata)
setdiff(NewRawData2$SampleTag,liverdata$SampleTag)
setdiff(liverdata$SampleTag,NewRawData2$SampleTag)
summary(NewRawData2$Intensity)
summary(liverdata$Intensity)


###################################################
### chunk number 13: sampleClusteredData
###################################################
JUNK_DATA <- sampleClusteredData(NewRawData2,no.peaks)
head(JUNK_DATA)[,1:5] 


###################################################
### chunk number 14: column1
###################################################
as.vector(t(matrix(liverdata[liverdata$SampleTag %in% 156,]$Intensity,53,2))[,1:5])
length(as.vector(t(matrix(liverdata[liverdata$SampleTag %in% 156,]$Intensity,53,2))))

as.vector(t(matrix(NewRawData2[NewRawData2$SampleTag %in% 156,]$Intensity,53,2))[,1:5])
length(as.vector(t(matrix(NewRawData2[NewRawData2$SampleTag %in% 156,]$Intensity,53,2))))


###################################################
### chunk number 15: createClassObject
###################################################
OBJECT=new("aclinicalProteomicsData")

OBJECT@rawSELDIdata=as.matrix(NewRawData2) #OBJECT@rawSELDIdata=as.matrix(liverdata)

OBJECT@covariates=c("tumor" ,    "sex")

OBJECT@phenotypicData=as.matrix(liver_pheno)

OBJECT@variableClass=c('numeric','factor','factor')

OBJECT@no.peaks=no.peaks

OBJECT



###################################################
### chunk number 16: ExtractComponetsOfeSet
###################################################
head(proteomicsExprsData(OBJECT))

head(proteomicspData(OBJECT))


###################################################
### chunk number 17: biologicalParameters
###################################################
intraclasscorr  <-  0.60 
signifcut <- 0.05  
Data=OBJECT

sampleSizeParameters(Data, intraclasscorr, signifcut)

Z <- as.vector(fisherInformation(Data)[2,2])/2
Z 
sampleSize(Data, intraclasscorr, signifcut)


###################################################
### chunk number 18: contourplot
###################################################
m <- 2
DIFF <- seq(0.1,0.50,0.01) 
VAR <- seq(0.2,4,0.1)
beta <- c(0.90,0.80,0.70)
alpha <-  1 - c(0.001, 0.01,0.05)/2
Corr <- c(0.70,0.90) 
Z <- 2.4   
Indicator <- 1 
observedPara <- c(1,0.4) #the variance you computed from pilot data
#observedPara <- data.frame(var=c(0.7,0.5,1.5),diFF=c(0.37,0.33,0.43))
sampleSizeContourPlots(Z,m,DIFF,VAR,beta,alpha,observedPara,Indicator)


###################################################
### chunk number 19: contourplot
###################################################
observedVAR=1 
observedDIFF=0.4 


###################################################
### chunk number 20: scatterplot
###################################################
Z <- 2.460018
m <- 2
DIFF <- seq(0.1,0.50,0.01) 
VAR <- seq(0.2,4,0.1)
beta <- c(0.90,0.80,0.70)
alpha  <-  1 - c(0.001, 0.01,0.05)/2
observedDIFF  <-  0.4
observedVAR  <-  1.0
observedSampleSize  <-  80
Indicator  <-  1 
Angle  <-  60    
sampleSize3DscatterPlots(Z,m,DIFF,VAR,beta,alpha,observedDIFF,observedVAR,observedSampleSize,Angle,Indicator)


###################################################
### chunk number 21: Writing the BibTex.bib file
###################################################
write(paste(
"@Article{Kunetal2006,
  author={Kun, Y. and Jianzhong, L. and Gao, H.},
  title={The impact of sample imbalance on identifying differentially expressed genes},
  journal={BMC Bioinformatics},
  year=2006,
  volume={7 (Suppl 4):S8},
  }",
"@Article{Cairnsetal2009,
   title =  {Sample size determination in clinical proteomic profiling experiments using mass spectrometry for class comparison},
   author = {Cairns, DA. and Barrett, JH. and Billingham, LJ. and Stanley, AJ. and Xinarianos, G. and Field, JK. and 
Johnson, PJ. and Selby, PJ. and Banks, RE.},
   journal= {Proteomics},
   year =   {2009},
   volume = {9},
  pages={74-86}
   }",
"@incollection{li2005,
  author  = {Li, X. and Gentleman, R. and Lu, X. and Shi, Q. and Iglehart, J.D. and Harris, L. and Miron, A.},
  title = {Mass spectrometry protein data},
  booktitle = {Bioinformatics and Computational Biology Solutions Using R and Bioconductor},
  editor =	 {Gentleman, R. and carey, V. and Huber, W. and Irizarry, R. and Dudoit, S.},
  address = {New York},
  publisher  = {Springer},
  year =	 {2005},
  chapter = {6},
  pages =	 {91--108},
}",
"@Article{DobinandSimon2005,
    title = {Sample Size Determination in Microarray Experiments for Class Comparison and Prognostic Classification},
    author = {Dobbin, K. and Simon, R.},
    journal= {Biostatistics},
    year = {2005},
    volume= {6},
    pages={27-38}
    }",
"@Article{WeiandBumgarner2004,
    title = {Sample size for detecting differentially expressed genes in microarray experiments. },
    author = {Wei, C. and Li, J. and Bumgarner, R.},
    journal= {BMC genomics},
    year = {2004},
    volume= {5(87): doi :10.1186/1471-2164-5-87},
       }",
"@Article{Jorstadetal2007,
    title = {Understanding sample size: what determines the required number of microarrays for an experiment},
    author = {Jrstad, TS. and Langaas, M. and Bones, AM.},
    journal= {TRENDS in Plant Science},
    year = {2007},
    volume= {12(2)},
    pages={46-50}
    }",
"@Article{Birkneretal2006,
    title = {Issues of Processing and Multiple Testing of SELDI-TOF MS Proteomic Data},
    author = {Birkner, MD. and Hubbard, AE. and van der Laan, MJ. and Skibola, CF. and Hegedus, CM. and Smith, MT.},
    journal= {Stat Appl Genet Mol Biol},
    year = {2006},
    volume= {5(1) Article 11},
       }",
"@TechReport{Nyangomaetal2009,
  author={Nyangoma, SO. and Ferreira, JA. and Collins, SI. and Altman, DG. and Johnson, PJ. and Billingham, LJ.},
  title={Sample size calculations for planning clinical proteomic profiling studies using mass spectrometry},
  year={2009},
  month={Jan},
  institution={Cancer Research UK Institute for Cancer Studies, University of Birmingham},
  type={Biostatistics Working Papers},
    number={1}
}",
"@TechReport{tuszynski2003,
  author={Tuszynski, J.},
  title={caMassClass: A package for processing and clissifying mass spectrometry data},
  year={2003},
  month={},
  institution={SAIC and the National Cancer Institute},
  type={Software},
    number={}
}",
" @Article{gentleman2004,
    author = {Gentleman, R. C. and Carey, V. J. and  Bates, D. M. and others},
    title = {Bioconductor: Open software development for computational biology and bioinformatics},
    journal = {Genome Biology},
    volume = {5},
    year = {2004},
    pages = {R80},
    url = {http://genomebiology.com/2004/5/10/R80},
  }",
"@Article{BoguskiandMcIntosh2003,
    title = {Biomedical informatics for proteomics},
    author = {Boguski, M. and McIntosh, M.},
    journal= {Nature},
    year = {2003},
    volume= {422(6928)},
      pages={233-7}
 }",
sep="\n"), file="LittBib.bib")


