###################################################
### chunk number 1: 
###################################################
require("limma")
arrayFiles  <- list.files(system.file("sampleData", package = "cghMCR"), 
     full.names = TRUE, pattern = "TCGA")
arrayFiles


###################################################
### chunk number 2: 
###################################################
rawData <- read.maimages(arrayFiles, source = "agilent", columns = 
    list(R = "rMedianSignal", G = "gMedianSignal", Rb = "rBGMedianSignal", 
    Gb = "gBGMedianSignal"), annotation = c("Row", "Col", "ControlType", 
    "ProbeName", "GeneName", "SystematicName", "PositionX", "PositionY", 
    "gIsFeatNonUnifOL", "rIsFeatNonUnifOL", "gIsBGNonUnifOL", "rIsBGNonUnifOL",
    "gIsFeatPopnOL", "rIsFeatPopnOL", "gIsBGPopnOL", "rIsBGPopnOL", 
    "rIsSaturated", "gIsSaturated"), names = basename(arrayFiles))


###################################################
### chunk number 3: 
###################################################
rawData$design <- c(-1, -1, -1)


###################################################
### chunk number 4: 
###################################################
ma <- normalizeWithinArrays(backgroundCorrect(rawData, method = "minimum"), method = "loess")


###################################################
### chunk number 5: 
###################################################
chrom <- gsub("chr([0-9XY]+):.*", "\\1", ma$genes[, "SystematicName"])
dropMe <- c(which(!chrom %in% c(1:22, "X", "Y")), which(ma$genes[, "ControlType"] != 0))


###################################################
### chunk number 6: 
###################################################
require(DNAcopy, quietly = TRUE)
set.seed(25)
cna <- CNA(ma$M[-dropMe, ], 
    gsub("chr([0-9XY]+):.*", "\\1", ma$genes[-dropMe, "SystematicName"]),
    as.numeric(gsub(".*:([0-9]+)-.*", "\\1", 
      ma$genes[-dropMe, "SystematicName"])),
    data.type = "logratio", sampleid = colnames(ma$M)) 
segData <- segment(smooth.CNA(cna)) 


###################################################
### chunk number 7: 
###################################################
mySeglist <- segData[["output"]]
head(mySeglist)


###################################################
### chunk number 8: 
###################################################
require(CNTools, quietly = TRUE)
data("sampleData", package = "CNTools")
head(sampleData)


###################################################
### chunk number 9: 
###################################################
data(geneInfo)
data(sampleData, package = "CNTools")
set.seed(1234)
convertedData <- getRS(CNSeg(sampleData[which(is.element(sampleData[, "ID"], sample(unique(sampleData[, "ID"]), 20))), ]), by = "gene", imput = FALSE, 
XY = FALSE, geneMap = geneInfo)


###################################################
### chunk number 10: 
###################################################
require(cghMCR, quietly = TRUE)
SGOLScores <- SGOL(convertedData, threshold = c(-0.2, 0.2), method = sum)
plot(SGOLScores)


###################################################
### chunk number 11: 
###################################################
GOIGains <- SGOLScores[which(as.numeric(unlist(gol(SGOLScores[, ]))) > 
     20), "gains"]
GOILosses <- SGOLScores[which(as.numeric(unlist(gol(SGOLScores[, ]))) < 
     -20), "losses"]
head(gol(GOIGains))


###################################################
### chunk number 12: 
###################################################
cghmcr <- cghMCR(segData, gapAllowed = 500, alteredLow = 0.9,
 alteredHigh = 0.9, recurrence = 100)
mcrs <- MCR(cghmcr)


###################################################
### chunk number 13: 
###################################################
head(cbind(mcrs[, c("chromosome", "status", "mcr.start", "mcr.end", 
                     "samples")])) 


###################################################
### chunk number 14: 
###################################################
mcrs <- mergeMCRProbes(mcrs[mcrs[, "chromosome"] == "7", ], as.data.frame(segData[["data"]]))
head(cbind(mcrs[, c("chromosome", "status", "mcr.start", "mcr.end", 
                     "probes")]))


###################################################
### chunk number 15: 
###################################################
sessionInfo()


