###################################################
### chunk number 1: 
###################################################
library(Rdisop)
molecule <- getMolecule("C2H5OH")
getFormula(molecule)
getMass(molecule)


###################################################
### chunk number 2: 
###################################################
essentialElements <- initializeCHNOPSMgKCaFe()
chlorophyll <- getMolecule("C55H72MgN4O5H", z=1, 
  elements=essentialElements)
isotopes <- getIsotope(chlorophyll, seq(1,4))
isotopes


###################################################
### chunk number 3: isotopes
###################################################
plot(t(isotopes), type="h", xlab="m/z", ylab="Intensity")


###################################################
### chunk number 4: 
###################################################
molecules <- decomposeMass(46.042, ppm=20)
molecules


###################################################
### chunk number 5: 
###################################################
length(decomposeMass(147.053))


###################################################
### chunk number 6: 
###################################################
# glutamic acid (C5H9NO4)
masses <- c(147.053, 148.056)
intensities <- c(93, 5.8)

molecules <- decomposeIsotopes(masses, intensities)
cbind(getFormula(molecules), getScore(molecules), getValid(molecules))


###################################################
### chunk number 7: 
###################################################
querymolecule <- subMolecules("C5H10NO4", "H")
getFormula(querymolecule)


