###################################################
### chunk number 1: 
###################################################
library(RTools4TB)
args(getSignatures)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## res <- getSignatures(field="gene", value="PCNA")
## head(res)


###################################################
### chunk number 3: 
###################################################
res <- getSignatures(field="experiment", value="GSE2004")


###################################################
### chunk number 4: 
###################################################
res <- getSignatures(field="platform", value="GPL96")


###################################################
### chunk number 5: 
###################################################
data(annotationList)
names(annotationList)
attach(annotationList)
annotationList[1:4,]
table(TableName)


###################################################
### chunk number 6: 
###################################################
#Signatures containing genes related to Cell-Cycle
cc <- getSignatures(field="annotation", value="HSA04110:CELL CYCLE", qValue=20)


###################################################
### chunk number 7: 
###################################################
query <- paste(grep("^8q", Keyword,val=T),collapse="|")
query
cc <- getSignatures(field="annotation", value=query, qValue=10)


###################################################
### chunk number 8: 
###################################################
gl <- getSignatures(field="gene", value="CD3D CD3E CD4", nbMin=2)
head(gl)


###################################################
### chunk number 9: 
###################################################
res <- getSignatures(field="gene", value="CD4")


###################################################
### chunk number 10: 
###################################################
res <- getSignatures(field="gene", value="CD4 & CD3E & !CD14")


###################################################
### chunk number 11: 
###################################################
res <- getSignatures(field="gene", value="CD4 & CD3E & !(CD19 | IGHM)")


###################################################
### chunk number 12: 
###################################################
TS <- getSignatures(field="gene", value="XBP1 & ESR1 & GATA3")
head(TS)
a <- getTBInfo(field="signature", value="3DE64836D", verbose=FALSE)
exp <- a["Experiment",1]
info <- getTBInfo(field="experiment", value=exp, verbose=TRUE)


###################################################
### chunk number 13: 
###################################################
library(biocGraph)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## adjMat <- createGraph4BioC(request="XBP1 & ESR1 & GATA3", prop=80)


###################################################
### chunk number 15: 
###################################################
adjMat <- as.matrix(read.table("ftp://tagc.univ-mrs.fr/public/TranscriptomeBrowser/RTools4TB/adjMat.txt", sep="\t", quote="", head=TRUE, row=1))


###################################################
### chunk number 16: graph
###################################################
g1 <- new("graphAM", adjMat=adjMat)
nodes(g1)
nAt <- makeNodeAttrs(g1)
nAt$fillcolor[match(rownames(as.matrix(nAt$fillcolor)), c("GATA3", "XBP1", "ESR1"), nomatch=F)!=0] <- "green"
nAt$fillcolor[match(rownames(as.matrix(nAt$fillcolor)), c("TBC1D9", "FOXA1"), nomatch=F)!=0] <- "yellow"
plot(g1,"fdp",nodeAttrs=nAt)


###################################################
### chunk number 17: 
###################################################
a <- getTBInfo(field="signature", value="3DE64836D", verbose=FALSE)
exp <- a["Experiment",1]
info <- getTBInfo(field="experiment", value=exp, verbose=TRUE)


###################################################
### chunk number 18: 
###################################################
sampleInfo <- getTBInfo(field="samples", value = "3DE64836D")
head(sampleInfo[,1:2])


###################################################
### chunk number 19: 
###################################################
em <- getExpressionMatrix(signatureID="3DE64836D")
class(em)


###################################################
### chunk number 20: 
###################################################
pdf(file="heat.pdf")


###################################################
### chunk number 21: 
###################################################
library(RColorBrewer)
col <- colorRampPalette(brewer.pal(10, "RdBu"))(256)
geneNames <- paste(em[,1],em[,2],sep="||")
em <- as.matrix(em[,-c(1,2)])
ind <- match(colnames(em), sampleInfo[,1])
colnames(em) <- sampleInfo[ind,2]
row <- rep(1,nrow(em))
ind <- grep("(XBP1)|(ESR1)|(GATA3)", geneNames,perl=TRUE)
row[ind] <- 2
rc <- rainbow(2, start=0, end=.3)
rc <- rc[row]
col <- colorRampPalette(brewer.pal(10, "RdBu"))(256)
split <- strsplit(colnames(em)," (", fixed=TRUE)
pheno <- unlist(lapply(split,"[",1))
pheno <- as.factor(pheno)
levels(pheno) <- 1:5
cc <- rainbow(5, start=0, end=.3)
cc <- cc[pheno]
heatmap(em, col=col, RowSideColors=rc, ColSideColors=cc, labRow=geneNames, cexRow=0.3)


###################################################
### chunk number 22: 
###################################################
dev.off()


###################################################
### chunk number 23: profil
###################################################
  plotGeneExpProfiles(data=em, X11=FALSE)


###################################################
### chunk number 24:  eval=FALSE
###################################################
## library(ALL)
## data(ALL)
## sub <- exprs(ALL)[1:3000,]


###################################################
### chunk number 25:  eval=FALSE
###################################################
## subNorm <- doNormalScore(sub)


###################################################
### chunk number 26: 
###################################################
args(DBFMCL)


###################################################
### chunk number 27:  eval=FALSE
###################################################
## res <- DBFMCL(subNorm, distance.method="pearson", memory=512)


###################################################
### chunk number 28:  eval=FALSE
###################################################
## class(res)


###################################################
### chunk number 29:  eval=FALSE
###################################################
## res


###################################################
### chunk number 30:  eval=FALSE
###################################################
##  head(res@data[,1:2])


###################################################
### chunk number 31:  eval=FALSE
###################################################
## slotNames(res)


###################################################
### chunk number 32:  eval=FALSE
###################################################
## res@size


###################################################
### chunk number 33:  eval=FALSE
###################################################
## res@data[res@cluster ==1,]


###################################################
### chunk number 34:  eval=FALSE
###################################################
## plotGeneExpProfiles(res, sign=1)


###################################################
### chunk number 35:  eval=FALSE
###################################################
## writeDBFMCLresult(res, filename.out="ALL.sign.txt")


