###################################################
### chunk number 1: 
###################################################
require("CNTools")
data(sampleData)
head(sampleData)


###################################################
### chunk number 2: 
###################################################
cnseg <- CNSeg(sampleData[which(is.element(sampleData[, "ID"], sample(unique(sampleData[, "ID"]), 20))), ])
rdseg <- getRS(cnseg, by = "region", imput = FALSE, XY = FALSE)
data("geneInfo")
geneInfo <- geneInfo[sample(1:nrow(geneInfo), 2000), ]
rdByGene <- getRS(cnseg, by = "gene", imput = FALSE, XY = FALSE, geneMap = geneInfo)


###################################################
### chunk number 3: 
###################################################
reducedseg <- rs(rdseg)


###################################################
### chunk number 4: 
###################################################
f1 <- kOverA(5, 1)
ffun <- filterfun(f1)
filteredrs <- genefilter(rdseg, ffun)


###################################################
### chunk number 5: 
###################################################
filteredrs <- madFilter(rdseg, 0.8)


###################################################
### chunk number 6: 
###################################################
hc <- hclust(getDist(filteredrs, method = "euclidian"), method = "complete") 
plot(hc, hang = -1, cex = 0.8, main = "", xlab = "")  


###################################################
### chunk number 7: 
###################################################
sessionInfo()


