### Name: "FCSmetadata-class"
### Title: Class "FCSmetadata" Metadata portion of a Flow Cytometry
###   Standard object
### Aliases: "FCSmetadata-class" "FCSmetadata" FCSmetadata-class
###   FCSmetadata "[",FCSmetadata-method
###   "subset-methods",FCSmetadata-method "[<-",FCSmetadata-method
###   "subsetassign-methods",FCSmetadata-method "[[",FCSmetadata-method
###   "subset2-methods",FCSmetadata-method "[[<-",FCSmetadata-method
###   "subset2assign-methods",FCSmetadata-method
###   "print-methods",FCSmetadata-method "show-methods",FCSmetadata-method
###   "summary-methods",FCSmetadata-method "["-methods,FCSmetadata-method
###   subset-methods,FCSmetadata-method "[<-"-methods,FCSmetadata-method
###   subsetassign-methods,FCSmetadata-method
###   "[["-methods,FCSmetadata-method subset2-methods,FCSmetadata-method
###   "[[<-"-methods,FCSmetadata-method
###   subset2assign-methods,FCSmetadata-method
###   print-methods,FCSmetadata-method show-methods,FCSmetadata-method
###   summary-methods,FCSmetadata-method "[",FCSmetadata-method
###   "[<-",FCSmetadata-method "[[",FCSmetadata-method
###   "[[<-"-methods,FCSmetadata-method print,FCSmetadata-method
###   show,FCSmetadata-method summary,FCSmetadata-method
### Keywords: classes

### ** Examples

default<-new("FCSmetadata")

some.meta<-new("FCSmetadata", fcsinfo=list("comment"=rep("none", 10)),
mode="none", nparam=0, size=0)

## extract/subset the metadata
some.meta[["nparam"]]
some.meta["paramranges"]
## replace the metadata/subsetassign the metadata
## 3 parameters with ranges
some.meta[["nparam"]]<-3
some.meta["paramranges"]<-rep(1,3)
## show
show(some.meta)
## print
print(some.meta)
some.meta
## summary
summary(some.meta)



