### Name: PRIM.real.data.min
### Title: PRIM output from VRCmin data analysis
### Aliases: PRIM.real.data.min out.expand out.peel out.cv Rule1.idx TD1
###   TD2 box.idx.list box.idx.listTD1 box.idx.listTD2 box.support.ES
###   box.support.PS means.ES means.PS type.ES type.PS best.box.X.ranges
### Keywords: datasets

### ** Examples

data(PRIM.real.data)

## the following code was used to generate the output
if (FALSE){

  data(VRCmin)
  ## the HIV-protein stimulation status
  Y <- c(rep(1, dim.FCS(st.1829)[1]), 
       rep(0, dim.FCS(unst.1829)[1]))

  ## the dataset
  X <- rbind(as(st.1829, "matrix"), as(unst.1829, "matrix"))
  if (require(rfcprim)){
  out.peel <- peel.step(X,
                      Y,
                      min.box.size = 500,
                      alpha=0.10,
                      verbose=TRUE)

  out.expand <- expand.step(X,
                          Y,
                          out.peel@best.box.idx,
                          beta=0.01,
                          verbose=TRUE)

  out.cv <- crossval.step(X,
                        Y,
                        num.testdata=2,
                        prob.testdata=c(0.50, 0.50),
                        alpha=0.10,
                        target.mu.Y=1,
                        min.box.size=500,
                        choose.best.box.decision=c("max.mean.box", "final.box"),
                       
                        beta=0.01,
                        verbose=TRUE)

  box.idx.list <- list(out.peel@best.box.idx,
     out.expand@best.box.idx)

  box.support.PS <- out.peel@box.support.vec

  means.PS <- out.peel@means.vec

  type.PS <- out.peel@type.vec

  box.support.ES <- out.expand@box.support.vec

  means.ES <- out.expand@means.vec

  type.ES <- out.expand@type.vec

  best.box.X.ranges <- out.expand@best.box.X.ranges

  Rule1.idx <- out.expand@best.box.idx

  TD1 <- out.cv[1, "testdata.idx.list"]
  TD2 <- out.cv[2, "testdata.idx.list"]

  box.idx.listTD1 <- list(out.cv[1,"step.set.list"]@peel.step@best.box.idx,
      out.cv[1, "step.set.list"]@expand.step@best.box.idx)

  box.idx.listTD2 <- list(out.cv[2,"step.set.list"]@peel.step@best.box.idx,
      out.cv[2, "step.set.list"]@expand.step@best.box.idx)
  }
 }




