rm(list=ls())
library(XML)
library(msbase)
library(gstat)
library(mscalib)
library(msmascot)

Sacc <- 0.05
Sig1 <- 65
Sig2 <- 60

DB <- c("NCBIMUSMUS","PIRULLELA","ARABI")
DB <- DB[1]


if(TRUE)
  {    
    plat<-"z:"
    plat<-"/home/arabidopsis/ewolski"
    fpD <- "/DATA/mouse/"
    fpP <- "/DATA/mouse/"
                                        #folderD <- "20031010u_dt_mouse_b1"
                                        #folderPPG <- "20031010u_dt_mouse_b1_ppg"
    folderD <- "20031010u_dt_mouse_b1_rec" #2
    folderPPG <- "20031010u_dt_mouse_b1_rec_ppg"
                                        #folderD <- "20031016u_dt_mouse_a1_1" #3
                                        #folderPPG <- "20031016u_dt_mouse_a1_1_ppg"
                                        #folderD <- "20031021u_dt_mouse_a1_1rec"
                                        #folderPPG <- "20031021u_dt_mouse_a1_1rec_ppg"
    #folderD <- "20031107u_jg_a1" #6
    #folderPPG <- "20031107u_jg_a1_ppg"
 }

NPPG <- readBruker( new("Massvectorlist") , paste(plat,fpP,folderPPG,sep="") )
object <- readBruker( new("Massvectorlist") , paste(plat,fpD,folderD,sep="") )
print(length(object))

#
#Cheat. 
#
res <- gamasses(object,accur=0.6,abund=length(object)/3)
all <- new("Massvector",matrix(c(1046.5423 ,1296.6853 ,1362.7356,1446.7494,1672.9175,2093.0867,2465.1989,3147.4715),ncol=1),info="kdk")
filt <- finterS(all,res,error=0.4,ppm=F) 
object<-fsetdiff(object , filt , error=400 , ppm=T)

##At first apply external calibration.


extcalib <- getextcalib(NPPG,ppm=F,error=0.5)
plot(extcalib)


res <- gamasses(object,accur=0.6,abund=length(object)/10)
data.precalib <- applycalib(object,extcalib)
res2 <- gamasses(data.precalib,accur=0.5,abund=length(object)/10)

par(mfrow=c(1,2))
par(mar=c(3,3,1,1))
data(cal2,package="mscalib")
plot(res,cal2)
plot(res2,cal2)

##
## End removal of higher order errors
##


##
## Get pepcalib and TPS calib
##

mod <- getpepcalib(data.precalib,mrange=c(20,1300))
#mod<-getprecalib(object)
mod2 <- refinecalibTps(mod,sdS=5e-4,sdI=0.2,full=TRUE,lambda=5e-2,lambdaF=1e-3)


par(mfrow=c(1,2))
image(mod,what="Coeff.Slope",col=bpy.colors(100),cex.axis=0.8)
image(mod2,what="Coeff.Slope",col=bpy.colors(100),cex.axis=.8)

data.precalib <- applycalib( data.precalib , mod2 )

                                        #plot
par(mfrow=c(2,1))
data(cal2,package="mscalib")
mrang <- c(2210,2213)
par(mar=c(3,3,1,1))
plot(object,xlim=mrang,main="",pch=2,col="darkgray",xlab="",ylab="",cex=0.6)
plot(data.precalib,add=T,col="darkolivegreen4",pch=3,cex=0.6)
abline(v=cal2[,1],col=2)
mrang <- c(842,843)
par(mar=c(3,3,1,1))
plot(object,xlim=mrang,main="",pch=2,col="darkgray",xlab="",ylab="",cex=0.6)
plot(data.precalib,add=T,col="darkolivegreen4",pch=3,cex=0.6)
abline(v=cal2[,1],col=2)



##
##Second Calibration.
##


abmasses <- gamasses(data.precalib,accur=0.4,abund=length(object)/13)
calib <- getintcalib(abmasses,cal2,error=200,ppm = TRUE )
abmasses <- applycalib(abmasses,calib)
mmemod <- getintcalib(data.precalib,abmasses,error=200,ppm=TRUE)

data.calib <- applycalib(data.precalib,mmemod)

##Plot Calibration results

par(mfrow=c(2,1))
mrang <- c(2210,2212)
par(mar=c(3,3,1,1))
plot(object,xlim=mrang,main="",pch=2,col="darkgray",xlab="",ylab="",cex=0.6)
plot(data.calib,add=T,col="blue",pch=3,cex=0.6)
abline(v=cal2[,1],col=2)
mrang <- c(842,842.7)
par(mar=c(3,3,1,1))
plot(object,xlim=mrang,main="",pch=2,col="darkgray",xlab="",ylab="",cex=0.6)
plot(data.calib,add=T,col="blue",pch=3,cex=0.6)
abline(v=cal2[,1],col=2)


##FILTERING OF Abundant masses

abmasses <- gamasses(data.calib,accur=0.2,abund=length(object)/13)


searchconfig <- getSearchconfig()
searchconfig$"DB"=DB
searchconfig$"TOL" = Sacc
searchconfig$"TOLU" <- "Da"
#search the abundant masses
res <- mascotSearch(abmasses , searchconfig,hits=5,minscore=60,research=TRUE,host="fugu")
summary(res)
tmp <- as.data.frame(res)
if(subset(tmp, research==1 & hitid==1)$score > 60)
{
  tmp <- getMatchedMass( res[[as.numeric(rownames(subset(tmp, research==1 & hitid==1)))]] )
  plot(tmp)
  abmasses <- fsetdiff(abmasses,tmp)
}


data.cfilter <- fsetdiff(data.calib,abmasses,error=0.15,ppm=F)

hist(data.calib,accur=0.3)
hist(data.cfilter,col=3,add=T,accur=0.3)


searchconfig$"DB" = DB
searchconfig$"TOL" = Sacc
searchconfig$"TOLU" <- "Da"
searchres <- mascotSearch(data.cfilter,searchconfig,hits=5,minscore=55,research=TRUE,host="fugu")
save(searchres,file=paste(folderD,Sacc,"LRPRINT.rda",sep=""))

load(file=paste(folderD,Sacc,"LRPRINT.rda",sep=""))
summary(searchres,sigscore=Sig1)
summary(searchres,sigscore=Sig2)


tmp <- as.data.frame(searchres)
tmp <- subset(tmp, research==1 & hitid==1)$score

hist(tmp,breaks=seq(0,max(tmp)+1,by=1))
abline(v=65,col=2)
