### Name: updateViews
### Title: Updates all Views After the Data Changes
### Aliases: updateViews
### Keywords: dynamic

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under 
    # the Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)  
    # now set the view mode
    setHighlightMode()

    # now click on a point on the plot and that will cause updateViews
    # to be called - you can tell it was called because the plot
    # will change
  }



