### Name: removeEnvView
### Title: Removes view information from environment variable, viewList
### Aliases: removeEnvView
### Keywords: data

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under 
    # the Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)  
    # now check viewList in viewEnv
    get("viewList",viewEnv)

    # now close the gtk window that has the scatterplot in it
    # closing the window will cause removeEnvView to be called

    # then check again viewList in viewEnv - that 
    # sPlotView object should be removed 
    get("viewList",viewEnv)    
  }



