### Name: removeDevices
### Title: Remove a gtk device from R's device list
### Aliases: removeDevices
### Keywords: device

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under 
    # the Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2) 
    # now check R's device list
    dev.list()

    # now close the gtk window that has the scatterplot in it
    # then check R's device list again - that device should be removed 
    dev.list()

    # in comparison
    w<-gtkWindow(show=FALSE)
    dr<-gtkDrawingArea()
    asGtkDevice(dr)
    w$Add(dr)
    w$Show()
    # now check R's device list
    dev.list()
    # now close the gtk window
    w$Destroy()
    # and again check R's device list 
    # the gtk device will still be in R's list (use dev.off to remove it)
    dev.list()
  }



