### Name: gUpdateDataMessage-class
### Title: Class "gUpdateDataMessage": A class to represent an update data
###   message
### Aliases: gUpdateDataMessage-class gUpdateDataMessage handleMessage to
###   to<- handleMessage,gUpdateDataMessage-method
###   initialize,gUpdateDataMessage-method to,gUpdateDataMessage-method
###   to<-,gUpdateDataMessage-method
### Keywords: classes

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under the 
    # Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)
    # should set highlight mode through Highlight under the ViewMode menu
    setHighlightMode() 
    # should create a gUpdateDataMessage object by clicking on the plot
    curpt<-identifyPoint(curplot=getActivePlot(),xyloc=list(x=2.7,y=72))
    dMessage<-new("gUpdateDataMessage",from=getActivePlot(),
                  where=curpt)
    handleMessage(dMessage)    
  }



