### Name: askToFind
### Title: Asks the user which row or data element they want to locate in a
###   view
### Aliases: askToFind getFindInfo
### Keywords: interface

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # loading data should be performed through the menu item 'open data'
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # createView should be performed through the menu item 'plot data'
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)
    # make the view mode be highlight - this should be performed by
    # choosing the Highlight menu item under the ViewMode menu 
    setHighlightMode()
    # should choose 'find' under edit menu to call askToFind()
    askToFind()
    # then enter the name of a state such as 'Minnesota' in the text box, 
    # set Find based on to Row, and click ok
  }



