### Name: addWindowMenu
### Title: Add a Menu for Windows to the Control Window
### Aliases: addWindowMenu
### Keywords: manip

### ** Examples

  if (interactive())
  {
    createControlWindow()
    # should load data through Open Data or Open File under the File menu
    data(USArrests)
    loadDFData(USArrests,"USArrests")
    # plotting the data should occur through Plot Data under 
    # the Display menu
    createView(type = "plotView", dataName = "USArrests", 
               plotType = "sPlotView", dfRows = 1:nrow(USArrests), 
               dfColumns = 1:2)  
    # now look at the Window menu on the control window - should
    # have 2 elements: Control Window and Window 1

    # now close the gtk window that has the scatterplot in it
    # closing the window will cause setDeleteEvents, and thus,
    # addWindowMenu to be called

    # now the Window menu on the control window should only have
    # 1 element, the Control Window
  }



