### Name: evalClusterHyper
### Title: Evaluates a clustering result with regard to an enrichment of
###   annotation terms in specific clusters.
### Aliases: evalClusterHyper evalAnnosetHyper
### Keywords: utilities

### ** Examples

## We will first creat a goCluster object to get the gene ontology
## annotation from it
data(benomylsetupsmall)
test <- new("goCluster")
setup(test) <- benomylsetupsmall
## Executing the data object will also execute the annotation
## object associated with it. The "execute" function needs
## to specify the "test" object a second time since we need
## to specify a parent object when executing a goCluster subobject.
annotation <- execute(test@data, test)
## Extract the annotation datasets and the unique ids
Annoset  <- annotation@anno@annoset
Uniqueid <- annotation@uniqueid

## Test clusters (the genes are specified by there position in
## the dataset)
testclusters <- list(
                     list(
                          c(68, 78),
                          c(32,  7, 72)
                          ),
                     list(c(31, 78)
                     ))

evalClusterHyper(testclusters, Uniqueid, Annoset)




