### Name: widget-class
### Title: Class "widget" creates a widget with primary widgets contained
###   in the list pWidgets rendered
### Aliases: widget-class env<- funs<- funs postFuns<- postFun preFuns<-
###   preFun pWidgets<- pWidgets updateCheck updateList updateRadio
###   updateText wTitle<- wTitle env<-,widget-method funs<-,widget-method
###   funs,widget-method postFuns<-,widget-method postFun,widget-method
###   preFuns<-,widget-method preFun,widget-method wEnv,widget-method
###   pWidgets<-,widget-method pWidgets,widget-method
###   updateCheck,widget-method updateList,widget-method
###   updateRadio,widget-method updateText,widget-method
###   wTitle<-,widget-method wTitle,widget-method
### Keywords: classes

### ** Examples

PWEnv <- new.env(hash = TRUE, parent = parent.frame(1))

label1 <- label(wName = "label1", wValue = "File Name: ", wEnv = PWEnv)
entry1 <- entryBox(wName = "entry1", wValue = "Feed me using browse",
                   wEnv = PWEnv)
browse2Entry1 <- function(){
    tempValue <- fileBrowser()
    temp <- get(wName(entry1), wEnv = PWEnv)
    wValue(temp) <- paste(tempValue, sep = "", collapse = ";")
    assign(wName(entry1), temp, env = PWEnv)
}
button1 <- button(wName = "button1", wValue = "Browse",
                     wFuns = list(command = browse2Entry1), wEnv = PWEnv)
list1 <- listBox(wName = "list1", wValue = c(Option1 = TRUE, Option2 = FALSE,
                                 Option3 = FALSE), wEnv = PWEnv)
text1 <- textBox(wName = "text1", wValue = "Feed me something",
                 wEnv = PWEnv)
label2 <- label(wName = "label2", wValue = "Select one:  ", wEnv = PWEnv)
radios1 <- radioButton(wName = "radios1", wValue = c(radio1 = TRUE,
                       radio2 = FALSE, radio3 = FALSE), wEnv = PWEnv)
label3 <- label(wName = "label3", wValue = "Select one to many: ",
wEnv = PWEnv)
checks1 <- checkButton(wName = "checks1", wValue = c(check1 = TRUE,
                       check22 = FALSE, check3 = FALSE), wEnv = PWEnv)
pWidgets <- list(topRow = list(label1 = label1, entry1 = entry1,
                 button1 = button1), textRow = list(list1 = list1,
                 text1 = text1), radGroup = list(label2 = label2,
                 radios1 = radios1), chkGroup = list(label3 = label3,
                                     checks1 = checks1))

## Not run: 
##D ## These cannot be run by examples() but should be OK when pasted
##D ## into an interactive R session with the widgetTools package loaded
##D 
##D aWidget <- widget(wTitle = "A test widget", pWidgets, funs = list(),
##D                  preFun = function() print("Hello"),
##D                  postFun = function() print("Bye"), env = PWEnv)
## End(Not run)



