### Name: getElement
### Title: Functions to extract atomic data types (numeric, character) and
###   vectors from an XML tree
### Aliases: getElement getVector
### Keywords: programming error

### ** Examples
 
  exfile = file.path(.path.package("prada"), "extdata", "dorit13_2c-1-2--13-Ytrail=3143937171.xml")
  z      = xmlTreeParse(exfile)
  r      = xmlRoot(z)[[2]]
  getElement(r[[3]], name="current clone", type="character")

  thenames = list("Area (pixels)", "Perimeter", "Projection x", "Projection y",
      "Longest Segment Length",
      list("x1Left", "y1Top", "x2Right", "y2Bottom"),
      "Number of Holes", "Hole's Area (pixels)", "Dapi mean",
      "Brdu mean", "transfection mean")
  thetypes = c(rep("numeric", 5), list(rep("numeric", 4)), rep("numeric", 5))

  getVector(r[[4]][[6]], name=NULL, elementnames=thenames, elementtypes=thetypes)
  getElement(r[[4]][[6]][[3]], "Area (pixels)")



