### Name: fbinary-methods
### Title: Methods for Function ``fbinary'' in Package `msbase'
### Aliases: fbinary-methods fbinary,numeric,numeric-method
###   fbinary,Massvector,Massvector-method
###   fbinary,Massvectorlist,Massvector-method
###   fbinary,Massvectorlist,NULL-method fbinary,list,NULL-method
### Keywords: methods

### ** Examples

# resolve multiple matches.
data(pldata)
pl1 <- pldata[[1]]
pl2 <- pldata[[2]]
fbinary(pl1,pl2,error=400,ppm=TRUE,theta=1,weight=FALSE,method="rmi",uniq=TRUE)
# dont resolve multiple matches.
fbinary(pl1,pl2,error=400,ppm=TRUE,theta=0.2,weight=FALSE,method="rmi",uniq=FALSE)
fbinary(pl1,pl2,error=400,ppm=TRUE,theta=0.2,weight=FALSE,method="hg")
fbinary(pl1,pl2,error=400,ppm=TRUE,theta=0.2,weight=TRUE,method="gower")
fbinary(pl1,pl2,error=400,ppm=TRUE,theta=0.2,weight=TRUE,method="fm")
# seach with one peak-list in a list of peak-lists.
fbinary(pldata,pl1,error=400,ppm=TRUE,theta=0.2,weight=TRUE,method="fm")
# compute distances (dissimilarities) and cluster.
tmp <- fbinary(pldata,NULL,error=400,ppm=TRUE,theta=0.2,weight=TRUE,method="fm")
plot(hclust(tmp,method="average"))



