### Name: plot.hexbin
### Title: plotting hexagon cells and legend
### Aliases: plot.hexbin
### Keywords: hplot

### ** Examples

## 1) simple binning of spherical normal:
x <- rnorm(10000)
y <- rnorm(10000)
bin <- hexbin(x,y)

# basic plot
plot(bin)
# nested lattice
plot(bin, style= "nested.lattice")

# controlling the colorscheme
plot(bin, colramp=BTY, colorcut=c(0,.1,.2,.3,.4,.6,1))

## 2) A mixture distribution
x <- c(rnorm(5000),rnorm(5000,4,1.5))
y <- c(rnorm(5000),rnorm(5000,2,3))
bin <- hexbin(x,y)

pens <- cbind(c("#ECE2F0","#A6BDDB","#1C9099"),
              c("#FFF7BC","#FEC44F","#D95F0E"))
plot(bin, style = "nested.lattice", pen=pens)
# now really crazy
plot(bin, style = "nested.lattice", pen=pens,border=2,density=35)

# lower resolution binning and overplotting with counts
oldpar <- par(no.readonly=TRUE)
bin <- hexbin(x,y,xbins=25)
scrPar <- plot.hexbin(bin, style= "lattice",legend=FALSE,
                      minarea=1,maxarea=1,border="white")
par(scrPar) # reset graphics to the plot on the screen
xy <- hcell2xy(bin)
text(xy$x,xy$y,as.character(bin$cnt),adj=.5,cex=.3,col="red")
points(x,y,pch=18,col="red") # to show points rather than counts
par(oldpar) # reset graphics

# Be creative, have fun!




