### Name: hexagons
### Title: Add Hexagon Cells to Plot
### Aliases: hexagons
### Keywords: aplot

### ** Examples


set.seed(506)
x <- rnorm(10000)
y <- rnorm(10000)

# bin the points
bin <- hexbin(x,y)

## setup coordinate system:
plot(bin$xbnd, bin$ybnd, type="n", main = "Bivariate rnorm(10000)", asp=1)
hexagons(bin)

#  A better approach uses plot.hexbin
#  which controls the plot shape :
plot(bin, main = "Bivariate rnorm(10000)")
## or
plot(hexbin(x, y + x*(x+1)/4),
     main = "(X, X(X+1)/4 + Y)  where X,Y ~ rnorm(10000)")

# A mixture distribution
x <- c(rnorm(5000),rnorm(5000,4,1.5))
y <- c(rnorm(5000),rnorm(5000,2,3))
bin <- hexbin(x,y)

# Show color control and overplotting of hexagons
plot(bin$xbnd, bin$ybnd, type="n", main = "Bivariate mixture (10000)", asp=1)
hexagons(bin, style= "lattice", border = gray(.1), pen = gray(.6),
         minarea = .1, maxarea = 1.5)
## How to treat 'singletons' specially:
plot(bin$xbnd, bin$ybnd, type="n", main = "Bivariate mixture (10000)", asp=1)
hexagons(bin, style= "nested.centroids", mincnt = 2)# not the single ones
hexagons(bin, style= "centroids", maxcnt = 1, maxarea=0.04)# single points

# And if we had all the information...
if(require(gpclib)){
  h1 <- chull(x[1:5000], y[1:5000])
  h2 <- chull(x[5001:10000], y[5001:10000])
  h2 <- h2+5000
  h1 <- as(cbind(x[1:5000],y [1:5000])[h1, ], "gpc.poly")
  h2 <- as(cbind(x,y)[h2, ], "gpc.poly")
  plot(bin$xbnd, bin$ybnd, type="n", main = "Bivariate mixture (10000)", asp=1)
  plot(h1,poly.args = list(col ="#CCEBC5"),add = TRUE)
  plot(h2,poly.args = list(col ="#FBB4AE"),add = TRUE)
  plot(intersect(h1, h2), poly.args = list(col = 2), add = TRUE)
  hexagons(bin, style= "centroids", border = gray(.1), pen = gray(.6),
           minarea = .1, maxarea = 1.5)
}




