### Name: hex3d.plot
### Title: A 3D version of plot.hexbin - EXPERIMENTAL
### Aliases: hex3d.plot
### Keywords: hplot

### ** Examples

## 1) simple binning of spherical normal:
x <- rnorm(10000)
y <- rnorm(10000)
bin <- hexbin(x,y)

# basic plot
hex3d.plot(bin)
# lattice (not really nicely 3D)
hex3d.plot(bin, style= "lattice")

# controlling the colorscheme
hex3d.plot(bin, colramp=BTY, colorcut=c(0:4,6,10)/10)

## 2) A mixture distribution
x <- c(rnorm(5000),rnorm(5000,4,1.5))
y <- c(rnorm(5000),rnorm(5000,2,3))
bin <- hexbin(x,y)

## UNFINISHED -- and FIXME : this gives warnings:
pens <- cbind(c("#ECE2F0","#A6BDDB","#1C9099"),
              c("#FFF7BC","#FEC44F","#D95F0E"))
hex3d.plot(bin, style = "lattice", pen=pens)

# lower resolution binning and overplotting with counts
bin <- hexbin(x,y,xbins=25)
oldpar <- par(no.readonly=TRUE)
scrPar <- hex3d.plot(bin, style= "lattice",legend=FALSE,
                      minarea=1,maxarea=1, border.base="white")
par(scrPar) # reset graphics to the plot on the screen
xy <- hcell2xy(bin)
text(xy$x,xy$y,as.character(bin$cnt),adj=.5, cex=.75, col="blue")
points(x,y,pch=".",col="red") # to show points rather than counts
par(oldpar) # reset graphics

# Be creative, have fun!




