hex3d.plot              package:hexbin              R Documentation

_A _3_D _v_e_r_s_i_o_n _o_f _p_l_o_t._h_e_x_b_i_n - _E_X_P_E_R_I_M_E_N_T_A_L

_D_e_s_c_r_i_p_t_i_o_n:

     A 3D-version of 'plot.hexbin' but *experimental*.

_U_s_a_g_e:

     hex3d.plot(x, inner = 0.7, style = c("colorscale", "centroids", "lattice"),
                legend = 1, lcex = 1,
                minarea = 0.04, maxarea = 0.8, mincnt = 1, maxcnt = max(x$cnt),
                trans = NULL, inv = NULL,
                colorcut = seq(0, 1, length = min(17, maxcnt)),
                tilt = 0, tilt.dir = 0, lt.angle = 145,
                lt.azimuth = 30, peak = NULL, pen = NULL,
                border.base = NULL, border.top = NULL, border.side = NULL,
                colramp = function(n) { LinGray(n, beg = 90, end = 15) },
                xlab = "", ylab = "", verbose = getOption("verbose"), ...)

_A_r_g_u_m_e_n_t_s:

       x: an object of class 'hexbin'.

   inner: ........ fraction .........

   style: string, one of '("colorscale", "lattice", "centroids" )', see
          'hexagons.3d'.

  legend: width of the legend in inches.  If False or 0 the legend is
          not produced.

    lcex: characters  expansion size for the text in the legend

 minarea: fraction of cell area for the lowest count

 maxarea: fraction of the cell area for the largest count

  mincnt: cells with fewer counts are ignored.

  maxcnt: cells with more counts are ignored.

   trans: 'function' specifying a transformation for the counts such as
          'sqrt'.

     inv: the inverse transformation of 'trans'.

colorcut: vector of  values covering [0, 1] that determine hexagon
          color class boundaries and hexagon legend size boundaries. 

    tilt: ~~Describe 'tilt' here~~ 

tilt.dir: ~~Describe 'tilt.dir' here~~ 

lt.angle: ~~Describe 'lt.angle' here~~ 

lt.azimuth: ~~Describe 'lt.azimuth' here~~ 

    peak: ~~Describe 'peak' here~~ 

     pen: Polygon() col argument. Determines the color with which the
          polygon will be filled

border.base: ~~Describe 'border.base' here~~ 

border.top: ~~Describe 'border.top' here~~ 

border.side: ~~Describe 'border.side' here~~ 

 colramp: function accepting an integer 'n' as an argument and
          returning n colors.

    xlab: xlabel argument to plot().

    ylab: ylabel argument to plot().

 verbose: logical indicating if some diagnostic output should happen.

     ...: additional arguments from and passed to  'plot' methods.

_V_a_l_u_e:

     invisible(par)

_S_e_e _A_l_s_o:

     'plot.hexbin', 'hex3d.legend',

_E_x_a_m_p_l_e_s:

     ## 1) simple binning of spherical normal:
     x <- rnorm(10000)
     y <- rnorm(10000)
     bin <- hexbin(x,y)

     # basic plot
     hex3d.plot(bin)
     # lattice (not really nicely 3D)
     hex3d.plot(bin, style= "lattice")

     # controlling the colorscheme
     hex3d.plot(bin, colramp=BTY, colorcut=c(0:4,6,10)/10)

     ## 2) A mixture distribution
     x <- c(rnorm(5000),rnorm(5000,4,1.5))
     y <- c(rnorm(5000),rnorm(5000,2,3))
     bin <- hexbin(x,y)

     ## UNFINISHED -- and FIXME : this gives warnings:
     pens <- cbind(c("#ECE2F0","#A6BDDB","#1C9099"),
                   c("#FFF7BC","#FEC44F","#D95F0E"))
     hex3d.plot(bin, style = "lattice", pen=pens)

     # lower resolution binning and overplotting with counts
     bin <- hexbin(x,y,xbins=25)
     oldpar <- par(no.readonly=TRUE)
     scrPar <- hex3d.plot(bin, style= "lattice",legend=FALSE,
                           minarea=1,maxarea=1, border.base="white")
     par(scrPar) # reset graphics to the plot on the screen
     xy <- hcell2xy(bin)
     text(xy$x,xy$y,as.character(bin$cnt),adj=.5, cex=.75, col="blue")
     points(x,y,pch=".",col="red") # to show points rather than counts
     par(oldpar) # reset graphics

     # Be creative, have fun!

