/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Document;

public class SchemaDOMParser
extends DefaultXMLDocumentHandler {
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected XMLLocator fLocator;
    SchemaDOM schemaDOM = new SchemaDOM();
    XMLParserConfiguration config;
    private int fAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;

    public void endDocument(Augmentations augs) throws XNIException {
    }

    public SchemaDOMParser(XMLParserConfiguration config) {
        this.config = config;
    }

    public Document getDocument() {
        return this.schemaDOM;
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.schemaDOM.endElement(element, augs);
        if (this.fAnnotationDepth == this.fDepth) {
            this.fAnnotationDepth = -1;
        }
        --this.fDepth;
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fAnnotationDepth == -1) {
            int i = text.offset;
            while (i < text.offset + text.length) {
                if (!XMLChar.isSpace(text.ch[i])) {
                    if (this.fErrorReporter == null) {
                        try {
                            this.fErrorReporter = (XMLErrorReporter)this.config.getProperty(ERROR_REPORTER);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                            XSMessageFormatter xmft = new XSMessageFormatter();
                            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", xmft);
                        }
                    }
                    String txt = new String(text.ch, i, text.length + text.offset - i);
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{txt}, (short)1);
                    break;
                }
                ++i;
            }
        } else {
            this.schemaDOM.characters(text, augs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.schemaDOM.emptyElement(element, attributes, augs, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.schemaDOM.startElement(element, attributes, augs, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber());
        ++this.fDepth;
        if (this.fAnnotationDepth == -1 && element.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && (element.localpart == SchemaSymbols.ELT_APPINFO || element.localpart == SchemaSymbols.ELT_DOCUMENTATION)) {
            this.fAnnotationDepth = this.fDepth;
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fLocator = locator;
    }
}

