/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.xs.TypeValidator;

public abstract class AbstractDateTimeDV
extends TypeValidator {
    private static final boolean DEBUG = false;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;

    public short getAllowedFacets() {
        return 2552;
    }

    private boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    protected int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    protected int maxDayInMonthFor(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (this.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    protected int fQuotient(int temp, int low, int high) {
        return this.fQuotient(temp - low, high - low);
    }

    protected int mod(int a, int b, int quotient) {
        return a - quotient * b;
    }

    protected int modulo(int temp, int low, int high) {
        int a = temp - low;
        int b = high - low;
        return this.mod(a, b, this.fQuotient(a, b)) + low;
    }

    protected void resetDateObj(int[] data) {
        int i = 0;
        while (i < 8) {
            data[i] = 0;
            ++i;
        }
    }

    protected short compareOrder(int[] date1, int[] date2) {
        int i = 0;
        while (i < 8) {
            if (date1[i] < date2[i]) {
                return -1;
            }
            if (date1[i] > date2[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    private void cloneDate(int[] finalValue, int[] tempDate) {
        System.arraycopy(finalValue, 0, tempDate, 0, 8);
    }

    protected void normalize(int[] date, int[] timeZone) {
        int negate = 1;
        if (date[7] == 43) {
            negate = -1;
        }
        int temp = date[4] + negate * timeZone[1];
        int carry = this.fQuotient(temp, 60);
        date[4] = this.mod(temp, 60, carry);
        temp = date[3] + negate * timeZone[0] + carry;
        carry = this.fQuotient(temp, 24);
        date[3] = this.mod(temp, 24, carry);
        date[2] = date[2] + carry;
        while (true) {
            temp = this.maxDayInMonthFor(date[0], date[1]);
            if (date[2] < 1) {
                date[2] = date[2] + this.maxDayInMonthFor(date[0], date[1] - 1);
                carry = -1;
            } else {
                if (date[2] <= temp) break;
                date[2] = date[2] - temp;
                carry = 1;
            }
            temp = date[1] + carry;
            date[1] = this.modulo(temp, 1, 13);
            date[0] = date[0] + this.fQuotient(temp, 1, 13);
        }
        date[7] = 90;
    }

    protected void validateDateTime(int[] data, int[] timeZone) {
        if (data[0] == 0) {
            throw new RuntimeException("The year \"0000\" is an illegal year value");
        }
        if (data[1] < 1 || data[1] > 12) {
            throw new RuntimeException("The month must have values 1 to 12");
        }
        if (data[2] > this.maxDayInMonthFor(data[0], data[1]) || data[2] < 1) {
            throw new RuntimeException("The day must have values 1 to 31");
        }
        if (data[3] > 23 || data[3] < 0) {
            throw new RuntimeException("Hour must have values 0-23");
        }
        if (data[4] > 59 || data[4] < 0) {
            throw new RuntimeException("Minute must have values 0-59");
        }
        if (data[5] > 60 || data[5] < 0) {
            throw new RuntimeException("Second must have values 0-60");
        }
        if (timeZone[0] > 14 || timeZone[0] < -14) {
            throw new RuntimeException("Time zone should have range -14..+14");
        }
        if (timeZone[1] > 59 || timeZone[1] < -59) {
            throw new RuntimeException("Minute must have values 0-59");
        }
    }

    protected short compareDates(int[] date1, int[] date2, boolean strict) {
        if (date1[7] == date2[7]) {
            return this.compareOrder(date1, date2);
        }
        int[] tempDate = new int[8];
        int[] timeZone = new int[2];
        if (date1[7] == 90) {
            this.cloneDate(date2, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 43;
            this.normalize(tempDate, timeZone);
            short c1 = this.compareOrder(date1, tempDate);
            this.cloneDate(date2, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 45;
            this.normalize(tempDate, timeZone);
            short c2 = this.compareOrder(date1, tempDate);
            if (c1 < 0 && c2 > 0 || c1 == 0 && c2 == 0) {
                return 2;
            }
            return c1 != 2 ? c1 : c2;
        }
        if (date2[7] == 90) {
            this.cloneDate(date1, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 45;
            this.normalize(tempDate, timeZone);
            short c1 = this.compareOrder(tempDate, date2);
            this.cloneDate(date1, tempDate);
            timeZone[0] = 14;
            timeZone[1] = 0;
            tempDate[7] = 43;
            this.normalize(tempDate, timeZone);
            short c2 = this.compareOrder(tempDate, date2);
            if (c1 < 0 && c2 > 0 || c1 == 0 && c2 == 0) {
                return 2;
            }
            return c1 != 2 ? c1 : c2;
        }
        return 2;
    }

    protected int parseIntYear(String buffer, int end) {
        int limit;
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int digit = 0;
        if (buffer.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / radix;
        while (i < end) {
            if ((digit = TypeValidator.getDigit(buffer.charAt(i++))) < 0) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
        }
        return -result;
    }

    protected int findUTCSign(String buffer, int start, int end) {
        int i = start;
        while (i < end) {
            char c = buffer.charAt(i);
            if (c == 'Z' || c == '+' || c == '-') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int parseInt(String buffer, int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        int digit = 0;
        int limit = -2147483647;
        int multmin = limit / radix;
        int i = start;
        do {
            if ((digit = TypeValidator.getDigit(buffer.charAt(i))) < 0) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer.toString() + "' has wrong format");
            }
            result -= digit;
        } while (++i < end);
        return -result;
    }

    protected int indexOf(String buffer, int start, int end, char ch) {
        int i = start;
        while (i < end) {
            if (buffer.charAt(i) == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getDate(String buffer, int start, int end, int[] date) throws RuntimeException {
        start = this.getYearMonth(buffer, start, end, date);
        if (buffer.charAt(start++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int stop = start + 2;
        date[2] = this.parseInt(buffer, start, stop);
        return stop;
    }

    protected int getYearMonth(String buffer, int start, int end, int[] date) throws RuntimeException {
        int i;
        if (buffer.charAt(0) == '-') {
            ++start;
        }
        if ((i = this.indexOf(buffer, start, end, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int length = i - start;
        if (length < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (length > 4 && buffer.charAt(start) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        date[0] = this.parseIntYear(buffer, i);
        if (buffer.charAt(i) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        start = ++i;
        i = start + 2;
        date[1] = this.parseInt(buffer, start, i);
        return i;
    }

    protected void getTime(String buffer, int start, int end, int[] data, int[] timeZone) throws RuntimeException {
        int stop = start + 2;
        data[3] = this.parseInt(buffer, start, stop);
        if (buffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data[4] = this.parseInt(buffer, start, stop += 2);
        if (buffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data[5] = this.parseInt(buffer, start, stop += 2);
        int milisec = this.indexOf(buffer, start, end, '.');
        int sign = this.findUTCSign(buffer, milisec != -1 ? milisec : start, end);
        if (milisec != -1) {
            data[6] = sign < 0 ? this.parseInt(buffer, milisec + 1, buffer.length()) : this.parseInt(buffer, milisec + 1, sign);
        }
        if (sign > 0) {
            this.getTimeZone(buffer, data, sign, end, timeZone);
        }
    }

    protected void parseTimeZone(String buffer, int start, int end, int[] date, int[] timeZone) throws RuntimeException {
        if (start < end) {
            int sign = this.findUTCSign(buffer, start, end);
            if (sign < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(buffer, date, sign, end, timeZone);
        }
    }

    protected void getTimeZone(String buffer, int[] data, int sign, int end, int[] timeZone) throws RuntimeException {
        data[7] = buffer.charAt(sign);
        if (buffer.charAt(sign) == 'Z') {
            if (end > ++sign) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (sign <= end - 6) {
            int stop = ++sign + 2;
            timeZone[0] = this.parseInt(buffer, sign, stop);
            if (buffer.charAt(stop++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            timeZone[1] = this.parseInt(buffer, stop, stop + 2);
            if (stop + 2 != end) {
                throw new RuntimeException("Error in parsing time zone");
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected String dateToString(int[] date) {
        StringBuffer message = new StringBuffer(25);
        this.append(message, date[0], 4);
        message.append('-');
        this.append(message, date[1], 2);
        message.append('-');
        this.append(message, date[2], 2);
        message.append('T');
        this.append(message, date[3], 2);
        message.append(':');
        this.append(message, date[4], 2);
        message.append(':');
        this.append(message, date[5], 2);
        message.append('.');
        message.append(date[6]);
        this.append(message, (char)date[7], 0);
        return message.toString();
    }

    protected void append(StringBuffer message, int value, int nch) {
        if (value < 0) {
            message.append('-');
            value = -value;
        }
        if (nch == 4) {
            if (value < 10) {
                message.append("000");
            } else if (value < 100) {
                message.append("00");
            } else if (value < 1000) {
                message.append("0");
            }
            message.append(value);
        } else if (nch == 2) {
            if (value < 10) {
                message.append('0');
            }
            message.append(value);
        } else if (value != 0) {
            message.append((char)value);
        }
    }

    public int compare(Object value1, Object value2) {
        return this.compareDates(((DateTimeData)value1).data, ((DateTimeData)value2).data, true);
    }

    static final class DateTimeData {
        final int[] data;
        final AbstractDateTimeDV type;
        private String canonical;

        public boolean equals(Object obj) {
            if (!(obj instanceof DateTimeData)) {
                return false;
            }
            int[] odata = ((DateTimeData)obj).data;
            return this.type.compareDates(this.data, odata, true) == 0;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = this.type.dateToString(this.data);
            }
            return this.canonical;
        }

        public DateTimeData(int[] data, AbstractDateTimeDV type) {
            this.data = data;
            this.type = type;
        }
    }
}

