/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XML11DTDScannerImpl;
import org.apache.xerces.impl.XML11DocumentScannerImpl;
import org.apache.xerces.impl.XML11NamespaceBinder;
import org.apache.xerces.impl.XMLDTDScannerImpl;
import org.apache.xerces.impl.XMLDocumentScannerImpl;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.XML11DTDProcessor;
import org.apache.xerces.impl.dtd.XML11DTDValidator;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDContentModelFilter;
import org.apache.xerces.xni.parser.XMLDTDFilter;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLVersionDetector
implements XMLComponent,
XMLDocumentScanner,
XMLDTDScanner {
    private static final char[] XML11_VERSION = new char[]{'1', '.', '1'};
    private static final char[] EXPECTED_VERSION_STRING = new char[]{'<', '?', 'x', 'm', 'l', ' ', 'v', 'e', 'r', 's', 'i', 'o', 'n', '=', ' ', ' ', ' ', ' ', ' '};
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String DTD_SCANNER_PROPERTY = "http://apache.org/xml/properties/internal/dtd-scanner";
    protected static final String DTD_VALIDATOR_PROPERTY = "http://apache.org/xml/properties/internal/validator/dtd";
    protected static final String DTD_PROCESSOR_PROPERTY = "http://apache.org/xml/properties/internal/dtd-processor";
    protected static final String NAMESPACE_BINDER_PROPERTY = "http://apache.org/xml/properties/internal/namespace-binder";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/dtd-scanner", "http://apache.org/xml/properties/internal/validator/dtd", "http://apache.org/xml/properties/internal/dtd-processor", "http://apache.org/xml/properties/internal/namespace-binder"};
    private static final String[] PROPERTY_DEFAULTS = new String[]{null, null, null, null, null, null, null};
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityScanner fEntityScanner = null;
    protected XMLComponentManager fComponentManager = null;
    protected XMLDocumentHandler fDocumentHandler = null;
    protected XMLDTDHandler fDTDHandler = null;
    protected XMLDTDContentModelHandler fDTDContentModelHandler = null;
    protected XMLDocumentScannerImpl fRealDocumentScanner = null;
    protected XMLDTDScannerImpl fRealDTDScanner = null;
    protected XMLDocumentScannerImpl fXML10DocScanner = null;
    protected XMLDTDScannerImpl fXML10DTDScanner = null;
    protected XML11DocumentScannerImpl fXML11DocScanner = null;
    protected XML11DTDScannerImpl fXML11DTDScanner = null;
    protected XML11DTDValidator fXML11DTDValidator = null;
    protected XML11DTDProcessor fXML11DTDProcessor = null;
    protected XML11NamespaceBinder fXML11NamespaceBinder = null;
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fXMLSymbol = "[xml]".intern();
    private XMLString fVersionNum = new XMLString();

    private short determineDocVersion() throws IOException {
        this.fEntityManager.setScannerVersion((short)2);
        XMLEntityScanner scanner = this.fEntityManager.getEntityScanner();
        if (!scanner.skipString("<?xml")) {
            return 1;
        }
        if (!scanner.skipSpaces()) {
            this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 5);
            return 1;
        }
        if (!scanner.skipString("version")) {
            this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 6);
            return 1;
        }
        scanner.skipSpaces();
        if (scanner.scanChar() != 61) {
            this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 13);
            return 1;
        }
        scanner.skipSpaces();
        int quoteChar = scanner.scanChar();
        XMLVersionDetector.EXPECTED_VERSION_STRING[14] = (char)quoteChar;
        int versionPos = 0;
        while (versionPos < XML11_VERSION.length) {
            XMLVersionDetector.EXPECTED_VERSION_STRING[15 + versionPos] = (char)scanner.scanChar();
            ++versionPos;
        }
        XMLVersionDetector.EXPECTED_VERSION_STRING[18] = (char)scanner.scanChar();
        this.fixupCurrentEntity(this.fEntityManager, EXPECTED_VERSION_STRING, 19);
        int matched = 0;
        while (matched < XML11_VERSION.length) {
            if (EXPECTED_VERSION_STRING[15 + matched] != XML11_VERSION[matched]) break;
            ++matched;
        }
        if (matched == XML11_VERSION.length) {
            return 2;
        }
        return 1;
    }

    private void reinitializePipelines(short pipelineType) {
        if (pipelineType == 2) {
            this.fEntityManager.setScannerVersion((short)2);
            if (this.fXML11DocScanner == null) {
                this.fXML11DocScanner = new XML11DocumentScannerImpl();
            }
            this.fRealDocumentScanner = this.fXML11DocScanner;
            if (this.fXML11DTDScanner == null) {
                this.fXML11DTDScanner = new XML11DTDScannerImpl();
            }
            this.fRealDTDScanner = this.fXML11DTDScanner;
            XMLDocumentFilter val = null;
            val = (XMLDocumentFilter)this.fComponentManager.getProperty(DTD_VALIDATOR_PROPERTY);
            if (val != null) {
                if (this.fXML11DTDValidator == null) {
                    this.fXML11DTDValidator = new XML11DTDValidator();
                }
                this.fXML11DTDValidator.reset(this.fComponentManager);
                if (val.getDocumentSource() != null) {
                    val.getDocumentSource().setDocumentHandler(this.fXML11DTDValidator);
                    this.fXML11DTDValidator.setDocumentSource(val.getDocumentSource());
                }
                if (val.getDocumentHandler() != null) {
                    val.getDocumentHandler().setDocumentSource(this.fXML11DTDValidator);
                    this.fXML11DTDValidator.setDocumentHandler(val.getDocumentHandler());
                }
            }
            XMLDocumentFilter nsb = null;
            nsb = (XMLDocumentFilter)this.fComponentManager.getProperty(NAMESPACE_BINDER_PROPERTY);
            if (nsb != null) {
                if (this.fXML11NamespaceBinder == null) {
                    this.fXML11NamespaceBinder = new XML11NamespaceBinder();
                }
                this.fXML11NamespaceBinder.reset(this.fComponentManager);
                if (nsb.getDocumentSource() != null) {
                    nsb.getDocumentSource().setDocumentHandler(this.fXML11NamespaceBinder);
                    this.fXML11NamespaceBinder.setDocumentSource(nsb.getDocumentSource());
                }
                if (nsb.getDocumentHandler() != null) {
                    nsb.getDocumentHandler().setDocumentSource(this.fXML11NamespaceBinder);
                    this.fXML11NamespaceBinder.setDocumentHandler(nsb.getDocumentHandler());
                }
            }
            XMLDTDFilter proc = null;
            proc = (XMLDTDFilter)this.fComponentManager.getProperty(DTD_PROCESSOR_PROPERTY);
            if (proc != null) {
                XMLDTDContentModelFilter cmProc;
                if (this.fXML11DTDProcessor == null) {
                    this.fXML11DTDProcessor = new XML11DTDProcessor();
                }
                this.fXML11DTDProcessor.reset(this.fComponentManager);
                if (proc.getDTDSource() != null) {
                    proc.getDTDSource().setDTDHandler(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDSource(proc.getDTDSource());
                }
                if (proc.getDTDHandler() != null) {
                    proc.getDTDHandler().setDTDSource(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDHandler(proc.getDTDHandler());
                }
                if ((cmProc = (XMLDTDContentModelFilter)this.fComponentManager.getProperty(DTD_PROCESSOR_PROPERTY)).getDTDContentModelSource() != null) {
                    cmProc.getDTDContentModelSource().setDTDContentModelHandler(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDContentModelSource(cmProc.getDTDContentModelSource());
                }
                if (cmProc.getDTDContentModelHandler() != null) {
                    cmProc.getDTDContentModelHandler().setDTDContentModelSource(this.fXML11DTDProcessor);
                    this.fXML11DTDProcessor.setDTDContentModelHandler(cmProc.getDTDContentModelHandler());
                }
            }
        } else {
            this.fEntityManager.setScannerVersion((short)1);
            if (this.fXML10DocScanner == null) {
                this.fXML10DocScanner = new XMLDocumentScannerImpl();
            }
            this.fRealDocumentScanner = this.fXML10DocScanner;
            if (this.fXML10DTDScanner == null) {
                this.fXML10DTDScanner = new XMLDTDScannerImpl();
            }
            this.fRealDTDScanner = this.fXML10DTDScanner;
        }
        this.fRealDocumentScanner.reset(this.fComponentManager);
        this.fRealDocumentScanner.setDocumentHandler(this.fDocumentHandler);
        this.fDocumentHandler.setDocumentSource(this.fRealDocumentScanner);
        this.fRealDTDScanner.reset(this.fComponentManager);
        this.fRealDTDScanner.setDTDHandler(this.fDTDHandler);
        this.fDTDHandler.setDTDSource(this.fRealDTDScanner);
        this.fRealDTDScanner.setDTDContentModelHandler(this.fDTDContentModelHandler);
        this.fDTDContentModelHandler.setDTDContentModelSource(this.fRealDTDScanner);
        this.fRealDocumentScanner.setProperty(DTD_SCANNER_PROPERTY, this.fRealDTDScanner);
    }

    public boolean scanDTDExternalSubset(boolean complete) throws IOException, XNIException {
        return false;
    }

    public boolean scanDocument(boolean complete) throws IOException, XNIException {
        return this.fRealDocumentScanner.scanDocument(complete);
    }

    public boolean scanDTDInternalSubset(boolean complete, boolean standalone, boolean hasExternalSubset) throws IOException, XNIException {
        return false;
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        throw new XMLConfigurationException(0, featureId);
    }

    public void setFeature(String featureId, boolean value) throws XMLConfigurationException {
    }

    private void fixupCurrentEntity(XMLEntityManager manager, char[] scannedChars, int length) {
        XMLEntityManager.ScannedEntity currentEntity = manager.getCurrentEntity();
        if (currentEntity.count - currentEntity.position + length > currentEntity.ch.length) {
            char[] tempCh = currentEntity.ch;
            currentEntity.ch = new char[length + currentEntity.count - currentEntity.position + 1];
            System.arraycopy(tempCh, 0, currentEntity.ch, 0, tempCh.length);
        }
        if (currentEntity.position < length) {
            System.arraycopy(currentEntity.ch, currentEntity.position, currentEntity.ch, length, currentEntity.count - currentEntity.position);
            currentEntity.count += length - currentEntity.position;
        } else {
            int i = length;
            while (i < currentEntity.position) {
                currentEntity.ch[i] = 32;
                ++i;
            }
        }
        System.arraycopy(scannedChars, 0, currentEntity.ch, 0, length);
        currentEntity.position = 0;
        currentEntity.lineNumber = 1;
        currentEntity.columnNumber = 1;
    }

    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    public void setDTDContentModelHandler(XMLDTDContentModelHandler handler) {
        this.fDTDContentModelHandler = handler;
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDHandler(XMLDTDHandler handler) {
        this.fDTDHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        this.fComponentManager = componentManager;
        int i = 14;
        while (i < EXPECTED_VERSION_STRING.length) {
            XMLVersionDetector.EXPECTED_VERSION_STRING[i] = 32;
            ++i;
        }
    }

    public void setInputSource(XMLInputSource inputSource) throws IOException {
        String encoding = this.fEntityManager.setupCurrentEntity(fXMLSymbol, inputSource, false, true);
        this.reinitializePipelines(this.determineDocVersion());
        this.fEntityManager.setEntityHandler(this.fRealDocumentScanner);
        this.fRealDocumentScanner.startEntity(fXMLSymbol, this.fEntityManager.getCurrentResourceIdentifier(), encoding);
    }

    public Boolean getFeatureDefault(String featureId) {
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
            } else if (property.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
            } else if (property.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)value;
            }
        }
    }
}

