/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends ChildNode {
    static final long serialVersionUID = 7931170150428474230L;
    protected String data;
    private static transient NodeList singletonNodeList = new NodeList(){

        public int getLength() {
            return 0;
        }

        public Node item(int index) {
            return null;
        }
    };

    public int getLength() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data.length();
    }

    public CharacterDataImpl() {
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (count < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int tailLength = Math.max(this.data.length() - count - offset, 0);
        try {
            String value = this.data.substring(0, offset) + (tailLength > 0 ? this.data.substring(offset + count, offset + count + tailLength) : "");
            this.setNodeValueInternal(value);
            this.ownerDocument().deletedText(this, offset, count);
        }
        catch (StringIndexOutOfBoundsException e) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, msg);
        }
    }

    public String getData() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public String getNodeValue() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public String substringData(int offset, int count) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int length = this.data.length();
        if (count < 0 || offset < 0 || offset > length - 1) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, msg);
        }
        int tailIndex = Math.min(offset + count, length);
        return this.data.substring(offset, tailIndex);
    }

    public void replaceData(int offset, int count, String data) throws DOMException {
        this.deleteData(offset, count);
        this.insertData(offset, data);
    }

    public void insertData(int offset, String data) throws DOMException {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            String value = new StringBuffer(this.data).insert(offset, data).toString();
            this.setNodeValueInternal(value);
            this.ownerDocument().insertedText(this, offset, data.length());
        }
        catch (StringIndexOutOfBoundsException e) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null);
            throw new DOMException(1, msg);
        }
    }

    public void appendData(String data) {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (data == null) {
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.setNodeValue(this.data + data);
    }

    public void setData(String value) throws DOMException {
        this.setNodeValue(value);
    }

    public void setNodeValue(String value) {
        this.setNodeValueInternal(value);
        this.ownerDocument().replacedText(this);
    }

    protected void setNodeValueInternal(String value) {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String oldvalue = this.data;
        CoreDocumentImpl ownerDocument = this.ownerDocument();
        ownerDocument.modifyingCharacterData(this);
        this.data = value;
        ownerDocument.modifiedCharacterData(this, oldvalue, value);
    }

    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    protected CharacterDataImpl(CoreDocumentImpl ownerDocument, String data) {
        super(ownerDocument);
        this.data = data;
    }
}

