/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Interface.HasHardware;
import org.biomage.Protocol.Hardware;
import org.biomage.Protocol.ParameterizableApplication;
import org.xml.sax.Attributes;

public class HardwareApplication
extends ParameterizableApplication
implements Serializable,
HasHardware {
    String serialNumber;
    protected Hardware hardware;

    public HardwareApplication() {
    }

    public HardwareApplication(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "serialNumber");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.serialNumber = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<HardwareApplication");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</HardwareApplication>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.serialNumber != null) {
            out.write(" serialNumber=\"" + this.serialNumber + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.hardware != null) {
            out.write("<Hardware_assnref>");
            out.write("<" + this.hardware.getModelClassName() + "_ref identifier=\"" + this.hardware.getIdentifier() + "\"/>");
            out.write("</Hardware_assnref>");
        }
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getModelClassName() {
        return new String("HardwareApplication");
    }

    public void setHardware(Hardware hardware) {
        this.hardware = hardware;
    }

    public Hardware getHardware() {
        return this.hardware;
    }
}

