/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.DesignElement;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.ArrayDesign.FeatureGroup;
import org.biomage.ArrayDesign.Zone;
import org.biomage.DesignElement.DesignElement;
import org.biomage.DesignElement.FeatureLocation;
import org.biomage.DesignElement.Position;
import org.biomage.Interface.HasControlFeatures;
import org.biomage.Interface.HasControlledFeatures;
import org.biomage.Interface.HasFeatureGroup;
import org.biomage.Interface.HasFeatureLocation;
import org.biomage.Interface.HasPosition;
import org.biomage.Interface.HasZone;
import org.xml.sax.Attributes;

public class Feature
extends DesignElement
implements Serializable,
HasZone,
HasFeatureGroup,
HasPosition,
HasControlledFeatures,
HasControlFeatures,
HasFeatureLocation {
    protected HasControlFeatures.ControlFeatures_list controlFeatures = new HasControlFeatures.ControlFeatures_list();
    protected HasControlledFeatures.ControlledFeatures_list controlledFeatures = new HasControlledFeatures.ControlledFeatures_list();
    protected Position position;
    protected Zone zone;
    protected FeatureLocation featureLocation;
    protected FeatureGroup featureGroup;

    public Feature() {
    }

    public Feature(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Feature");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Feature>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.controlFeatures.size() > 0) {
            out.write("<ControlFeatures_assnreflist>");
            for (i = 0; i < this.controlFeatures.size(); ++i) {
                modelClassName = ((Feature)this.controlFeatures.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Feature)this.controlFeatures.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</ControlFeatures_assnreflist>");
        }
        if (this.controlledFeatures.size() > 0) {
            out.write("<ControlledFeatures_assnreflist>");
            for (i = 0; i < this.controlledFeatures.size(); ++i) {
                modelClassName = ((Feature)this.controlledFeatures.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Feature)this.controlledFeatures.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</ControlledFeatures_assnreflist>");
        }
        if (this.position != null) {
            out.write("<Position_assn>");
            this.position.writeMAGEML(out);
            out.write("</Position_assn>");
        }
        if (this.zone != null) {
            out.write("<Zone_assnref>");
            out.write("<" + this.zone.getModelClassName() + "_ref identifier=\"" + this.zone.getIdentifier() + "\"/>");
            out.write("</Zone_assnref>");
        }
        if (this.featureLocation != null) {
            out.write("<FeatureLocation_assn>");
            this.featureLocation.writeMAGEML(out);
            out.write("</FeatureLocation_assn>");
        }
        if (this.featureGroup != null) {
            out.write("<FeatureGroup_assnref>");
            out.write("<" + this.featureGroup.getModelClassName() + "_ref identifier=\"" + this.featureGroup.getIdentifier() + "\"/>");
            out.write("</FeatureGroup_assnref>");
        }
    }

    public String getModelClassName() {
        return new String("Feature");
    }

    public void setControlFeatures(HasControlFeatures.ControlFeatures_list controlFeatures) {
        this.controlFeatures = controlFeatures;
    }

    public HasControlFeatures.ControlFeatures_list getControlFeatures() {
        return this.controlFeatures;
    }

    public void addToControlFeatures(Feature feature) {
        this.controlFeatures.add(feature);
    }

    public void addToControlFeatures(int position, Feature feature) {
        this.controlFeatures.add(position, feature);
    }

    public Feature getFromControlFeatures(int position) {
        return (Feature)this.controlFeatures.get(position);
    }

    public void removeElementAtFromControlFeatures(int position) {
        this.controlFeatures.removeElementAt(position);
    }

    public void removeFromControlFeatures(Feature feature) {
        this.controlFeatures.remove(feature);
    }

    public void setControlledFeatures(HasControlledFeatures.ControlledFeatures_list controlledFeatures) {
        this.controlledFeatures = controlledFeatures;
    }

    public HasControlledFeatures.ControlledFeatures_list getControlledFeatures() {
        return this.controlledFeatures;
    }

    public void addToControlledFeatures(Feature feature) {
        this.controlledFeatures.add(feature);
    }

    public void addToControlledFeatures(int position, Feature feature) {
        this.controlledFeatures.add(position, feature);
    }

    public Feature getFromControlledFeatures(int position) {
        return (Feature)this.controlledFeatures.get(position);
    }

    public void removeElementAtFromControlledFeatures(int position) {
        this.controlledFeatures.removeElementAt(position);
    }

    public void removeFromControlledFeatures(Feature feature) {
        this.controlledFeatures.remove(feature);
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setFeatureLocation(FeatureLocation featureLocation) {
        this.featureLocation = featureLocation;
    }

    public FeatureLocation getFeatureLocation() {
        return this.featureLocation;
    }

    public void setFeatureGroup(FeatureGroup featureGroup) {
        this.featureGroup = featureGroup;
    }

    public FeatureGroup getFeatureGroup() {
        return this.featureGroup;
    }
}

