/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioSequence;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import org.biomage.BioSequence.SeqFeatureLocation;
import org.biomage.Common.Describable;
import org.biomage.Interface.HasRegions;
import org.xml.sax.Attributes;

public class SeqFeature
extends Describable
implements Serializable,
HasRegions {
    Basis basis = new Basis();
    protected HasRegions.Regions_list regions = new HasRegions.Regions_list();

    public SeqFeature() {
    }

    public SeqFeature(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "basis");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.basis.setValueByName(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<SeqFeature");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</SeqFeature>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.basis != null) {
            out.write(" basis=\"" + this.basis + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.regions.size() > 0) {
            out.write("<Regions_assnlist>");
            for (int i = 0; i < this.regions.size(); ++i) {
                ((SeqFeatureLocation)this.regions.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Regions_assnlist>");
        }
    }

    public void setBasis(Basis basis) {
        this.basis = basis;
    }

    public Basis getBasis() {
        return this.basis;
    }

    public String setNameByValueBasis(int val) {
        return this.getBasis().setNameByValue(val);
    }

    public int setValueByNameBasis(String name) {
        return this.getBasis().setValueByName(name);
    }

    public String getNameByValueBasis(int val) {
        return this.getBasis().getNameByValue(val);
    }

    public int getValueByNameBasis(String name) {
        return this.getBasis().getValueByName(name);
    }

    public String getNameBasis() {
        return this.getBasis().getName();
    }

    public int getValueBasis() {
        return this.getBasis().getValue();
    }

    public String getModelClassName() {
        return new String("SeqFeature");
    }

    public void setRegions(HasRegions.Regions_list regions) {
        this.regions = regions;
    }

    public HasRegions.Regions_list getRegions() {
        return this.regions;
    }

    public void addToRegions(SeqFeatureLocation seqFeatureLocation) {
        this.regions.add(seqFeatureLocation);
    }

    public void addToRegions(int position, SeqFeatureLocation seqFeatureLocation) {
        this.regions.add(position, seqFeatureLocation);
    }

    public SeqFeatureLocation getFromRegions(int position) {
        return (SeqFeatureLocation)this.regions.get(position);
    }

    public void removeElementAtFromRegions(int position) {
        this.regions.removeElementAt(position);
    }

    public void removeFromRegions(SeqFeatureLocation seqFeatureLocation) {
        this.regions.remove(seqFeatureLocation);
    }

    public class Basis {
        int value = -1;
        String name = null;
        private HashMap nameToValue = new HashMap(5);
        private HashMap valueToName = new HashMap(5);
        public final int experimental = 0;
        public final int computational = 1;
        public final int both = 2;
        public final int unknown = 3;
        public final int NA = 4;

        Basis() {
            this.nameToValue.put("experimental", new Integer(0));
            this.valueToName.put(new Integer(0), "experimental");
            this.nameToValue.put("computational", new Integer(1));
            this.valueToName.put(new Integer(1), "computational");
            this.nameToValue.put("both", new Integer(2));
            this.valueToName.put(new Integer(2), "both");
            this.nameToValue.put("unknown", new Integer(3));
            this.valueToName.put(new Integer(3), "unknown");
            this.nameToValue.put("NA", new Integer(4));
            this.valueToName.put(new Integer(4), "NA");
        }

        public int setValueByName(String name) {
            this.value = (Integer)this.nameToValue.get(name);
            return this.value;
        }

        public int getValueByName(String name) {
            return (Integer)this.nameToValue.get(name);
        }

        public String setNameByValue(int val) {
            this.name = (String)this.valueToName.get(new Integer(val));
            return this.name;
        }

        public String getNameByValue(int val) {
            return (String)this.valueToName.get(new Integer(val));
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getNameByValue(this.getValue());
        }
    }
}

