/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioMaterial;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioMaterial.CompoundMeasurement;
import org.biomage.Common.Identifiable;
import org.biomage.Description.DatabaseEntry;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasComponentCompounds;
import org.biomage.Interface.HasExternalLIMS;
import org.biomage.Interface.HasMerckIndex;
import org.xml.sax.Attributes;

public class Compound
extends Identifiable
implements Serializable,
HasComponentCompounds,
HasMerckIndex,
HasExternalLIMS {
    Boolean isSolvent;
    protected OntologyEntry merckIndex;
    protected HasComponentCompounds.ComponentCompounds_list componentCompounds = new HasComponentCompounds.ComponentCompounds_list();
    protected DatabaseEntry externalLIMS;

    public Compound() {
    }

    public Compound(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "isSolvent");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.isSolvent = new Boolean(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Compound");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Compound>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.isSolvent != null) {
            out.write(" isSolvent=\"" + this.isSolvent + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.merckIndex != null) {
            out.write("<MerckIndex_assn>");
            this.merckIndex.writeMAGEML(out);
            out.write("</MerckIndex_assn>");
        }
        if (this.componentCompounds.size() > 0) {
            out.write("<ComponentCompounds_assnlist>");
            for (int i = 0; i < this.componentCompounds.size(); ++i) {
                ((CompoundMeasurement)this.componentCompounds.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ComponentCompounds_assnlist>");
        }
        if (this.externalLIMS != null) {
            out.write("<ExternalLIMS_assn>");
            this.externalLIMS.writeMAGEML(out);
            out.write("</ExternalLIMS_assn>");
        }
    }

    public void setIsSolvent(Boolean isSolvent) {
        this.isSolvent = isSolvent;
    }

    public Boolean getIsSolvent() {
        return this.isSolvent;
    }

    public String getModelClassName() {
        return new String("Compound");
    }

    public void setMerckIndex(OntologyEntry merckIndex) {
        this.merckIndex = merckIndex;
    }

    public OntologyEntry getMerckIndex() {
        return this.merckIndex;
    }

    public void setComponentCompounds(HasComponentCompounds.ComponentCompounds_list componentCompounds) {
        this.componentCompounds = componentCompounds;
    }

    public HasComponentCompounds.ComponentCompounds_list getComponentCompounds() {
        return this.componentCompounds;
    }

    public void addToComponentCompounds(CompoundMeasurement compoundMeasurement) {
        this.componentCompounds.add(compoundMeasurement);
    }

    public void addToComponentCompounds(int position, CompoundMeasurement compoundMeasurement) {
        this.componentCompounds.add(position, compoundMeasurement);
    }

    public CompoundMeasurement getFromComponentCompounds(int position) {
        return (CompoundMeasurement)this.componentCompounds.get(position);
    }

    public void removeElementAtFromComponentCompounds(int position) {
        this.componentCompounds.removeElementAt(position);
    }

    public void removeFromComponentCompounds(CompoundMeasurement compoundMeasurement) {
        this.componentCompounds.remove(compoundMeasurement);
    }

    public void setExternalLIMS(DatabaseEntry externalLIMS) {
        this.externalLIMS = externalLIMS;
    }

    public DatabaseEntry getExternalLIMS() {
        return this.externalLIMS;
    }
}

