/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioAssayData;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioAssayData.BioAssayDimension;
import org.biomage.BioAssayData.BioDataValues;
import org.biomage.BioAssayData.DesignElementDimension;
import org.biomage.BioAssayData.QuantitationTypeDimension;
import org.biomage.Common.Identifiable;
import org.biomage.Common.NameValueType;
import org.biomage.Interface.HasBioAssayDimension;
import org.biomage.Interface.HasBioDataValues;
import org.biomage.Interface.HasDesignElementDimension;
import org.biomage.Interface.HasQuantitationTypeDimension;
import org.biomage.Interface.HasSummaryStatistics;
import org.xml.sax.Attributes;

public abstract class BioAssayData
extends Identifiable
implements Serializable,
HasBioAssayDimension,
HasDesignElementDimension,
HasQuantitationTypeDimension,
HasSummaryStatistics,
HasBioDataValues {
    protected HasSummaryStatistics.SummaryStatistics_list summaryStatistics = new HasSummaryStatistics.SummaryStatistics_list();
    protected BioAssayDimension bioAssayDimension;
    protected DesignElementDimension designElementDimension;
    protected QuantitationTypeDimension quantitationTypeDimension;
    protected BioDataValues bioDataValues;

    public BioAssayData() {
    }

    public BioAssayData(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.summaryStatistics.size() > 0) {
            out.write("<SummaryStatistics_assnlist>");
            for (int i = 0; i < this.summaryStatistics.size(); ++i) {
                ((NameValueType)this.summaryStatistics.elementAt(i)).writeMAGEML(out);
            }
            out.write("</SummaryStatistics_assnlist>");
        }
        if (this.bioAssayDimension != null) {
            out.write("<BioAssayDimension_assnref>");
            out.write("<" + this.bioAssayDimension.getModelClassName() + "_ref identifier=\"" + this.bioAssayDimension.getIdentifier() + "\"/>");
            out.write("</BioAssayDimension_assnref>");
        }
        if (this.designElementDimension != null) {
            out.write("<DesignElementDimension_assnref>");
            out.write("<" + this.designElementDimension.getModelClassName() + "_ref identifier=\"" + this.designElementDimension.getIdentifier() + "\"/>");
            out.write("</DesignElementDimension_assnref>");
        }
        if (this.quantitationTypeDimension != null) {
            out.write("<QuantitationTypeDimension_assnref>");
            out.write("<" + this.quantitationTypeDimension.getModelClassName() + "_ref identifier=\"" + this.quantitationTypeDimension.getIdentifier() + "\"/>");
            out.write("</QuantitationTypeDimension_assnref>");
        }
        if (this.bioDataValues != null) {
            out.write("<BioDataValues_assn>");
            this.bioDataValues.writeMAGEML(out);
            out.write("</BioDataValues_assn>");
        }
    }

    public String getModelClassName() {
        return new String("BioAssayData");
    }

    public void setSummaryStatistics(HasSummaryStatistics.SummaryStatistics_list summaryStatistics) {
        this.summaryStatistics = summaryStatistics;
    }

    public HasSummaryStatistics.SummaryStatistics_list getSummaryStatistics() {
        return this.summaryStatistics;
    }

    public void addToSummaryStatistics(NameValueType nameValueType) {
        this.summaryStatistics.add(nameValueType);
    }

    public void addToSummaryStatistics(int position, NameValueType nameValueType) {
        this.summaryStatistics.add(position, nameValueType);
    }

    public NameValueType getFromSummaryStatistics(int position) {
        return (NameValueType)this.summaryStatistics.get(position);
    }

    public void removeElementAtFromSummaryStatistics(int position) {
        this.summaryStatistics.removeElementAt(position);
    }

    public void removeFromSummaryStatistics(NameValueType nameValueType) {
        this.summaryStatistics.remove(nameValueType);
    }

    public void setBioAssayDimension(BioAssayDimension bioAssayDimension) {
        this.bioAssayDimension = bioAssayDimension;
    }

    public BioAssayDimension getBioAssayDimension() {
        return this.bioAssayDimension;
    }

    public void setDesignElementDimension(DesignElementDimension designElementDimension) {
        this.designElementDimension = designElementDimension;
    }

    public DesignElementDimension getDesignElementDimension() {
        return this.designElementDimension;
    }

    public void setQuantitationTypeDimension(QuantitationTypeDimension quantitationTypeDimension) {
        this.quantitationTypeDimension = quantitationTypeDimension;
    }

    public QuantitationTypeDimension getQuantitationTypeDimension() {
        return this.quantitationTypeDimension;
    }

    public void setBioDataValues(BioDataValues bioDataValues) {
        this.bioDataValues = bioDataValues;
    }

    public BioDataValues getBioDataValues() {
        return this.bioDataValues;
    }
}

