/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.ArrayDesign;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.ArrayDesign.DesignElementGroup;
import org.biomage.Description.OntologyEntry;
import org.biomage.DesignElement.Feature;
import org.biomage.Interface.HasDistanceUnit;
import org.biomage.Interface.HasFeatureShape;
import org.biomage.Interface.HasFeatures;
import org.biomage.Interface.HasTechnologyType;
import org.biomage.Measurement.DistanceUnit;
import org.xml.sax.Attributes;

public class FeatureGroup
extends DesignElementGroup
implements Serializable,
HasDistanceUnit,
HasFeatures,
HasTechnologyType,
HasFeatureShape {
    Float featureWidth;
    Float featureLength;
    Float featureHeight;
    protected OntologyEntry technologyType;
    protected OntologyEntry featureShape;
    protected DistanceUnit distanceUnit;
    protected HasFeatures.Features_list features = new HasFeatures.Features_list();

    public FeatureGroup() {
    }

    public FeatureGroup(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "featureWidth");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.featureWidth = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "featureLength")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.featureLength = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "featureHeight")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.featureHeight = new Float(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<FeatureGroup");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</FeatureGroup>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.featureWidth != null) {
            out.write(" featureWidth=\"" + this.featureWidth + "\"");
        }
        if (this.featureLength != null) {
            out.write(" featureLength=\"" + this.featureLength + "\"");
        }
        if (this.featureHeight != null) {
            out.write(" featureHeight=\"" + this.featureHeight + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.technologyType != null) {
            out.write("<TechnologyType_assn>");
            this.technologyType.writeMAGEML(out);
            out.write("</TechnologyType_assn>");
        }
        if (this.featureShape != null) {
            out.write("<FeatureShape_assn>");
            this.featureShape.writeMAGEML(out);
            out.write("</FeatureShape_assn>");
        }
        if (this.distanceUnit != null) {
            out.write("<DistanceUnit_assn>");
            this.distanceUnit.writeMAGEML(out);
            out.write("</DistanceUnit_assn>");
        }
        if (this.features.size() > 0) {
            out.write("<Features_assnlist>");
            for (int i = 0; i < this.features.size(); ++i) {
                ((Feature)this.features.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Features_assnlist>");
        }
    }

    public void setFeatureWidth(Float featureWidth) {
        this.featureWidth = featureWidth;
    }

    public Float getFeatureWidth() {
        return this.featureWidth;
    }

    public void setFeatureLength(Float featureLength) {
        this.featureLength = featureLength;
    }

    public Float getFeatureLength() {
        return this.featureLength;
    }

    public void setFeatureHeight(Float featureHeight) {
        this.featureHeight = featureHeight;
    }

    public Float getFeatureHeight() {
        return this.featureHeight;
    }

    public String getModelClassName() {
        return new String("FeatureGroup");
    }

    public void setTechnologyType(OntologyEntry technologyType) {
        this.technologyType = technologyType;
    }

    public OntologyEntry getTechnologyType() {
        return this.technologyType;
    }

    public void setFeatureShape(OntologyEntry featureShape) {
        this.featureShape = featureShape;
    }

    public OntologyEntry getFeatureShape() {
        return this.featureShape;
    }

    public void setDistanceUnit(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public DistanceUnit getDistanceUnit() {
        return this.distanceUnit;
    }

    public void setFeatures(HasFeatures.Features_list features) {
        this.features = features;
    }

    public HasFeatures.Features_list getFeatures() {
        return this.features;
    }

    public void addToFeatures(Feature feature) {
        this.features.add(feature);
    }

    public void addToFeatures(int position, Feature feature) {
        this.features.add(position, feature);
    }

    public Feature getFromFeatures(int position) {
        return (Feature)this.features.get(position);
    }

    public void removeElementAtFromFeatures(int position) {
        this.features.removeElementAt(position);
    }

    public void removeFromFeatures(Feature feature) {
        this.features.remove(feature);
    }
}

