/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Array;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Array.Array;
import org.biomage.Array.ManufactureLIMS;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.Common.Identifiable;
import org.biomage.Common.NameValueType;
import org.biomage.Interface.HasArrayManufacturers;
import org.biomage.Interface.HasArrays;
import org.biomage.Interface.HasFeatureLIMSs;
import org.biomage.Interface.HasProtocolApplications;
import org.biomage.Interface.HasQualityControlStatistics;
import org.biomage.Protocol.ProtocolApplication;
import org.xml.sax.Attributes;

public class ArrayManufacture
extends Identifiable
implements Serializable,
HasArrays,
HasProtocolApplications,
HasFeatureLIMSs,
HasArrayManufacturers,
HasQualityControlStatistics {
    String manufacturingDate;
    Float tolerance;
    protected HasArrays.Arrays_list arrays = new HasArrays.Arrays_list();
    protected HasArrayManufacturers.ArrayManufacturers_list arrayManufacturers = new HasArrayManufacturers.ArrayManufacturers_list();
    protected HasQualityControlStatistics.QualityControlStatistics_list qualityControlStatistics = new HasQualityControlStatistics.QualityControlStatistics_list();
    protected HasFeatureLIMSs.FeatureLIMSs_list featureLIMSs = new HasFeatureLIMSs.FeatureLIMSs_list();
    protected HasProtocolApplications.ProtocolApplications_list protocolApplications = new HasProtocolApplications.ProtocolApplications_list();

    public ArrayManufacture() {
    }

    public ArrayManufacture(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "manufacturingDate");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.manufacturingDate = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "tolerance")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.tolerance = new Float(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<ArrayManufacture");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</ArrayManufacture>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.manufacturingDate != null) {
            out.write(" manufacturingDate=\"" + this.manufacturingDate + "\"");
        }
        if (this.tolerance != null) {
            out.write(" tolerance=\"" + this.tolerance + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.arrays.size() > 0) {
            out.write("<Arrays_assnreflist>");
            for (i = 0; i < this.arrays.size(); ++i) {
                modelClassName = ((Array)this.arrays.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Array)this.arrays.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Arrays_assnreflist>");
        }
        if (this.arrayManufacturers.size() > 0) {
            out.write("<ArrayManufacturers_assnreflist>");
            for (i = 0; i < this.arrayManufacturers.size(); ++i) {
                modelClassName = ((Contact)this.arrayManufacturers.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Contact)this.arrayManufacturers.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</ArrayManufacturers_assnreflist>");
        }
        if (this.qualityControlStatistics.size() > 0) {
            out.write("<QualityControlStatistics_assnlist>");
            for (i = 0; i < this.qualityControlStatistics.size(); ++i) {
                ((NameValueType)this.qualityControlStatistics.elementAt(i)).writeMAGEML(out);
            }
            out.write("</QualityControlStatistics_assnlist>");
        }
        if (this.featureLIMSs.size() > 0) {
            out.write("<FeatureLIMSs_assnlist>");
            for (i = 0; i < this.featureLIMSs.size(); ++i) {
                ((ManufactureLIMS)this.featureLIMSs.elementAt(i)).writeMAGEML(out);
            }
            out.write("</FeatureLIMSs_assnlist>");
        }
        if (this.protocolApplications.size() > 0) {
            out.write("<ProtocolApplications_assnlist>");
            for (i = 0; i < this.protocolApplications.size(); ++i) {
                ((ProtocolApplication)this.protocolApplications.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ProtocolApplications_assnlist>");
        }
    }

    public void setManufacturingDate(String manufacturingDate) {
        this.manufacturingDate = manufacturingDate;
    }

    public String getManufacturingDate() {
        return this.manufacturingDate;
    }

    public void setTolerance(Float tolerance) {
        this.tolerance = tolerance;
    }

    public Float getTolerance() {
        return this.tolerance;
    }

    public String getModelClassName() {
        return new String("ArrayManufacture");
    }

    public void setArrays(HasArrays.Arrays_list arrays) {
        this.arrays = arrays;
    }

    public HasArrays.Arrays_list getArrays() {
        return this.arrays;
    }

    public void addToArrays(Array array) {
        this.arrays.add(array);
    }

    public void addToArrays(int position, Array array) {
        this.arrays.add(position, array);
    }

    public Array getFromArrays(int position) {
        return (Array)this.arrays.get(position);
    }

    public void removeElementAtFromArrays(int position) {
        this.arrays.removeElementAt(position);
    }

    public void removeFromArrays(Array array) {
        this.arrays.remove(array);
    }

    public void setArrayManufacturers(HasArrayManufacturers.ArrayManufacturers_list arrayManufacturers) {
        this.arrayManufacturers = arrayManufacturers;
    }

    public HasArrayManufacturers.ArrayManufacturers_list getArrayManufacturers() {
        return this.arrayManufacturers;
    }

    public void addToArrayManufacturers(Contact contact) {
        this.arrayManufacturers.add(contact);
    }

    public void addToArrayManufacturers(int position, Contact contact) {
        this.arrayManufacturers.add(position, contact);
    }

    public Contact getFromArrayManufacturers(int position) {
        return (Contact)this.arrayManufacturers.get(position);
    }

    public void removeElementAtFromArrayManufacturers(int position) {
        this.arrayManufacturers.removeElementAt(position);
    }

    public void removeFromArrayManufacturers(Contact contact) {
        this.arrayManufacturers.remove(contact);
    }

    public void setQualityControlStatistics(HasQualityControlStatistics.QualityControlStatistics_list qualityControlStatistics) {
        this.qualityControlStatistics = qualityControlStatistics;
    }

    public HasQualityControlStatistics.QualityControlStatistics_list getQualityControlStatistics() {
        return this.qualityControlStatistics;
    }

    public void addToQualityControlStatistics(NameValueType nameValueType) {
        this.qualityControlStatistics.add(nameValueType);
    }

    public void addToQualityControlStatistics(int position, NameValueType nameValueType) {
        this.qualityControlStatistics.add(position, nameValueType);
    }

    public NameValueType getFromQualityControlStatistics(int position) {
        return (NameValueType)this.qualityControlStatistics.get(position);
    }

    public void removeElementAtFromQualityControlStatistics(int position) {
        this.qualityControlStatistics.removeElementAt(position);
    }

    public void removeFromQualityControlStatistics(NameValueType nameValueType) {
        this.qualityControlStatistics.remove(nameValueType);
    }

    public void setFeatureLIMSs(HasFeatureLIMSs.FeatureLIMSs_list featureLIMSs) {
        this.featureLIMSs = featureLIMSs;
    }

    public HasFeatureLIMSs.FeatureLIMSs_list getFeatureLIMSs() {
        return this.featureLIMSs;
    }

    public void addToFeatureLIMSs(ManufactureLIMS manufactureLIMS) {
        this.featureLIMSs.add(manufactureLIMS);
    }

    public void addToFeatureLIMSs(int position, ManufactureLIMS manufactureLIMS) {
        this.featureLIMSs.add(position, manufactureLIMS);
    }

    public ManufactureLIMS getFromFeatureLIMSs(int position) {
        return (ManufactureLIMS)this.featureLIMSs.get(position);
    }

    public void removeElementAtFromFeatureLIMSs(int position) {
        this.featureLIMSs.removeElementAt(position);
    }

    public void removeFromFeatureLIMSs(ManufactureLIMS manufactureLIMS) {
        this.featureLIMSs.remove(manufactureLIMS);
    }

    public void setProtocolApplications(HasProtocolApplications.ProtocolApplications_list protocolApplications) {
        this.protocolApplications = protocolApplications;
    }

    public HasProtocolApplications.ProtocolApplications_list getProtocolApplications() {
        return this.protocolApplications;
    }

    public void addToProtocolApplications(ProtocolApplication protocolApplication) {
        this.protocolApplications.add(protocolApplication);
    }

    public void addToProtocolApplications(int position, ProtocolApplication protocolApplication) {
        this.protocolApplications.add(position, protocolApplication);
    }

    public ProtocolApplication getFromProtocolApplications(int position) {
        return (ProtocolApplication)this.protocolApplications.get(position);
    }

    public void removeElementAtFromProtocolApplications(int position) {
        this.protocolApplications.removeElementAt(position);
    }

    public void removeFromProtocolApplications(ProtocolApplication protocolApplication) {
        this.protocolApplications.remove(protocolApplication);
    }
}

