/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Array;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import org.biomage.Array.Array;
import org.biomage.Array.Fiducial;
import org.biomage.Common.Identifiable;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasArrays;
import org.biomage.Interface.HasDistanceUnit;
import org.biomage.Interface.HasFiducials;
import org.biomage.Interface.HasSubstrateType;
import org.biomage.Measurement.DistanceUnit;
import org.xml.sax.Attributes;

public class ArrayGroup
extends Identifiable
implements Serializable,
HasArrays,
HasFiducials,
HasDistanceUnit,
HasSubstrateType {
    String barcode;
    Float arraySpacingX;
    Float arraySpacingY;
    Integer numArrays;
    String orientationMark;
    OrientationMarkPosition orientationMarkPosition = new OrientationMarkPosition();
    Float width;
    Float length;
    protected HasFiducials.Fiducials_list fiducials = new HasFiducials.Fiducials_list();
    protected HasArrays.Arrays_list arrays = new HasArrays.Arrays_list();
    protected OntologyEntry substrateType;
    protected DistanceUnit distanceUnit;

    public ArrayGroup() {
    }

    public ArrayGroup(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "barcode");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.barcode = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "arraySpacingX")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.arraySpacingX = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "arraySpacingY")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.arraySpacingY = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "numArrays")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.numArrays = new Integer(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "orientationMark")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.orientationMark = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "orientationMarkPosition")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.orientationMarkPosition.setValueByName(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "width")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.width = new Float(atts.getValue(nIndex));
        }
        if ((nIndex = atts.getIndex("", "length")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.length = new Float(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<ArrayGroup");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</ArrayGroup>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.barcode != null) {
            out.write(" barcode=\"" + this.barcode + "\"");
        }
        if (this.arraySpacingX != null) {
            out.write(" arraySpacingX=\"" + this.arraySpacingX + "\"");
        }
        if (this.arraySpacingY != null) {
            out.write(" arraySpacingY=\"" + this.arraySpacingY + "\"");
        }
        if (this.numArrays != null) {
            out.write(" numArrays=\"" + this.numArrays + "\"");
        }
        if (this.orientationMark != null) {
            out.write(" orientationMark=\"" + this.orientationMark + "\"");
        }
        if (this.orientationMarkPosition != null) {
            out.write(" orientationMarkPosition=\"" + this.orientationMarkPosition + "\"");
        }
        if (this.width != null) {
            out.write(" width=\"" + this.width + "\"");
        }
        if (this.length != null) {
            out.write(" length=\"" + this.length + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.fiducials.size() > 0) {
            out.write("<Fiducials_assnlist>");
            for (i = 0; i < this.fiducials.size(); ++i) {
                ((Fiducial)this.fiducials.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Fiducials_assnlist>");
        }
        if (this.arrays.size() > 0) {
            out.write("<Arrays_assnreflist>");
            for (i = 0; i < this.arrays.size(); ++i) {
                String modelClassName = ((Array)this.arrays.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Array)this.arrays.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</Arrays_assnreflist>");
        }
        if (this.substrateType != null) {
            out.write("<SubstrateType_assn>");
            this.substrateType.writeMAGEML(out);
            out.write("</SubstrateType_assn>");
        }
        if (this.distanceUnit != null) {
            out.write("<DistanceUnit_assn>");
            this.distanceUnit.writeMAGEML(out);
            out.write("</DistanceUnit_assn>");
        }
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setArraySpacingX(Float arraySpacingX) {
        this.arraySpacingX = arraySpacingX;
    }

    public Float getArraySpacingX() {
        return this.arraySpacingX;
    }

    public void setArraySpacingY(Float arraySpacingY) {
        this.arraySpacingY = arraySpacingY;
    }

    public Float getArraySpacingY() {
        return this.arraySpacingY;
    }

    public void setNumArrays(Integer numArrays) {
        this.numArrays = numArrays;
    }

    public Integer getNumArrays() {
        return this.numArrays;
    }

    public void setOrientationMark(String orientationMark) {
        this.orientationMark = orientationMark;
    }

    public String getOrientationMark() {
        return this.orientationMark;
    }

    public void setOrientationMarkPosition(OrientationMarkPosition orientationMarkPosition) {
        this.orientationMarkPosition = orientationMarkPosition;
    }

    public OrientationMarkPosition getOrientationMarkPosition() {
        return this.orientationMarkPosition;
    }

    public String setNameByValueOrientationMarkPosition(int val) {
        return this.getOrientationMarkPosition().setNameByValue(val);
    }

    public int setValueByNameOrientationMarkPosition(String name) {
        return this.getOrientationMarkPosition().setValueByName(name);
    }

    public String getNameByValueOrientationMarkPosition(int val) {
        return this.getOrientationMarkPosition().getNameByValue(val);
    }

    public int getValueByNameOrientationMarkPosition(String name) {
        return this.getOrientationMarkPosition().getValueByName(name);
    }

    public String getNameOrientationMarkPosition() {
        return this.getOrientationMarkPosition().getName();
    }

    public int getValueOrientationMarkPosition() {
        return this.getOrientationMarkPosition().getValue();
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public Float getWidth() {
        return this.width;
    }

    public void setLength(Float length) {
        this.length = length;
    }

    public Float getLength() {
        return this.length;
    }

    public String getModelClassName() {
        return new String("ArrayGroup");
    }

    public void setFiducials(HasFiducials.Fiducials_list fiducials) {
        this.fiducials = fiducials;
    }

    public HasFiducials.Fiducials_list getFiducials() {
        return this.fiducials;
    }

    public void addToFiducials(Fiducial fiducial) {
        this.fiducials.add(fiducial);
    }

    public void addToFiducials(int position, Fiducial fiducial) {
        this.fiducials.add(position, fiducial);
    }

    public Fiducial getFromFiducials(int position) {
        return (Fiducial)this.fiducials.get(position);
    }

    public void removeElementAtFromFiducials(int position) {
        this.fiducials.removeElementAt(position);
    }

    public void removeFromFiducials(Fiducial fiducial) {
        this.fiducials.remove(fiducial);
    }

    public void setArrays(HasArrays.Arrays_list arrays) {
        this.arrays = arrays;
    }

    public HasArrays.Arrays_list getArrays() {
        return this.arrays;
    }

    public void addToArrays(Array array) {
        this.arrays.add(array);
    }

    public void addToArrays(int position, Array array) {
        this.arrays.add(position, array);
    }

    public Array getFromArrays(int position) {
        return (Array)this.arrays.get(position);
    }

    public void removeElementAtFromArrays(int position) {
        this.arrays.removeElementAt(position);
    }

    public void removeFromArrays(Array array) {
        this.arrays.remove(array);
    }

    public void setSubstrateType(OntologyEntry substrateType) {
        this.substrateType = substrateType;
    }

    public OntologyEntry getSubstrateType() {
        return this.substrateType;
    }

    public void setDistanceUnit(DistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public DistanceUnit getDistanceUnit() {
        return this.distanceUnit;
    }

    public class OrientationMarkPosition {
        int value = -1;
        String name = null;
        private HashMap nameToValue = new HashMap(4);
        private HashMap valueToName = new HashMap(4);
        public final int top = 0;
        public final int bottom = 1;
        public final int left = 2;
        public final int right = 3;

        OrientationMarkPosition() {
            this.nameToValue.put("top", new Integer(0));
            this.valueToName.put(new Integer(0), "top");
            this.nameToValue.put("bottom", new Integer(1));
            this.valueToName.put(new Integer(1), "bottom");
            this.nameToValue.put("left", new Integer(2));
            this.valueToName.put(new Integer(2), "left");
            this.nameToValue.put("right", new Integer(3));
            this.valueToName.put(new Integer(3), "right");
        }

        public int setValueByName(String name) {
            this.value = (Integer)this.nameToValue.get(name);
            return this.value;
        }

        public int getValueByName(String name) {
            return (Integer)this.nameToValue.get(name);
        }

        public String setNameByValue(int val) {
            this.name = (String)this.valueToName.get(new Integer(val));
            return this.name;
        }

        public String getNameByValue(int val) {
            return (String)this.valueToName.get(new Integer(val));
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getNameByValue(this.getValue());
        }
    }
}

