### Name: partial.cor
### Title: Partial Correlation from Correlation Matrix (and Vice Versa)
### Aliases: partial.cor cor2pcor pcor2cor
### Keywords: multivariate

### ** Examples

# load GeneTS library
library(GeneTS)

# covariance matrix
m.cov <- rbind(
 c(3,1,1,0),
 c(1,3,0,1),
 c(1,0,2,0),
 c(0,1,0,2)
)
m.cov

# corresponding correlation matrix
m.cor.1 <- cov2cor(m.cov)
m.cor.1

# compute partial correlations (from covariance matrix)
m.pcor.1 <- cor2pcor(m.cov)
m.pcor.1

# compute partial correlations (from correlation matrix)
m.pcor.2 <- cor2pcor(m.cor.1)
m.pcor.2

zapsmall( m.pcor.1 ) == zapsmall( m.pcor.2 )

# backtransformation
m.cor.2 <- pcor2cor(m.pcor.1)
m.cor.2
zapsmall( m.cor.1 ) == zapsmall( m.cor.2 )

# speed comparison
n <- 20
p <- 800
X <- matrix(rnorm(n*p), n, p)

system.time( p1 <- cor2pcor(cor(X)) )
system.time( p2 <- partial.cor(X) )

# p2 is much faster but still the same as p1!
eps <- 1e-10
sum(abs(p1-p2) > eps)




