### Name: mat.util
### Title: Various Matrix Utilities
### Aliases: is.positive.definite make.positive.definite rank.condition
###   is.square is.symmetric
### Keywords: array

### ** Examples

# load GeneTS library
library(GeneTS)

# Hilbert matrix
hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }

# positive definite ?
m <- hilbert(8)
is.positive.definite(m)

# numerically ill-conditioned
m <- hilbert(15)
rank.condition(m)

# make positive definite
m2 <- make.positive.definite(m)
is.positive.definite(m2)
rank.condition(m2)
m2 - m

# square and symmetric ?
is.square(m)
is.symmetric(m)



