### Name: glad
### Title: Analysis of array CGH data
### Aliases: glad glad.profileCGH


### ** Examples


data(snijders)
profileCGH <- list(profileValues=gm13330)
class(profileCGH) <- "profileCGH"

res <- glad(profileCGH, smoothfunc="laws", base=FALSE,
               bandwidth=10, round=2, lambdabreak=8, lambdacluster=8,
               lambdaclusterGen=40, alpha=0.001, method="centroid",
               nmax=8, lkern="exponential", model="Gaussian",
               qlambda=0.999)

# color code for region status

col <- rep("yellow",length(res$profileValues$PosOrder))
col[which(res$profileValues$ZoneGNL==-1)] <- "green"
col[which(res$profileValues$ZoneGNL==1)] <- "red"

# outliers

outliers <- rep(20,length(res$profileValues$PosOrder))
outliers[which(res$profileValues$OutliersTot!=0)] <- 13

plot(LogRatio ~ PosOrder, data=res$profileValues, col=col, pch=outliers)

# Limit between chromosomes

LimitChr <- unique(res$profileValues$LimitChr)+0.5
abline(v=LimitChr, col="grey", lty=2)

lines(res$profileValues$Smoothing ~ res$profileValues$PosOrder, col="black")

# Breakpoints identified

indexBP <- which(res$profileValues$Breakpoints==1)
BP <- res$profileValues$PosOrder[indexBP]+0.5
abline(v=BP, col="red", lty=2)




